package com.gogirl.domain.store.complaint;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 投诉明细
 * </p>
 *
 * @author luobin
 * @since 2019-11-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "ComplaintDetailed对象", description = "投诉明细")
public class ComplaintDetailed implements Serializable {

    private static final long serialVersionUID = 1L;
    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "complaint_sku_type = 1：store_business_sku complaint_sku_type = 2：store_reception_sku")
    private Integer skuId;

    private LocalDateTime createDate;

    @ApiModelProperty(value = "评价的具体内容")
    private String content;

    @ApiModelProperty(value = "客诉sku类型 店务sku = 1,接待服务 = 2, 产品 = 3, 技术 = 4 ")
    private Integer complaintSkuType;

    @ApiModelProperty(value = "投诉id")
    private Integer mainId;

    @ApiModelProperty(value = "sku名称")
    private String skuName;


}
