package com.gogirl.application.xcx.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.xcx.MessageService;
import com.gogirl.domain.store.oa.TakeLeaveEvent;
import com.gogirl.domain.store.store.Message;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.mapper.store.store.MessageMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@AllArgsConstructor
@Transactional
@Slf4j
public class MessageServiceImpl extends ServiceImpl<MessageMapper, Message> implements MessageService {

    private final MessageMapper messageMapper;

    @Override
    public Page<Message> selectMyMessage(Integer pageNum, Integer pageSize, Integer type, Integer tab) {
        IPage<Message> page = new Page<>(pageNum, pageSize);
        Integer technicianId = SessionUtils.getTechnicianId();
        page = messageMapper.selectMyMessage(page, technicianId, type, tab);
        page.getRecords().forEach(val -> {
            if (val.getType() == 1 || val.getType() == 3)
                val.setTakeLeaveEvent(JsonUtilByFsJson.jsonToBean(val.getParamJson(), TakeLeaveEvent.class));
        });
        return (Page<Message>) page;
    }

    @Override
    public List<Message> myMessageManage(Integer tab) {
        List<Message> list = messageMapper.myMessageManage(SessionUtils.getTechnicianId(), tab);
        list.forEach(message -> {
            Integer unread = messageMapper.selectUnReadCount(message.getTechnicianId(), message.getType());
            message.setUnread(unread);
        });
        return list;
    }

    @Override
    public void readMessage(Integer id) {
        Message message = messageMapper.selectById(id);
        message.setIsRead(1);
        messageMapper.updateById(message);
    }
}
