package com.gogirl.application.market;

import com.gogirl.shared.market.command.SetTimesCardCommand;
import com.gogirl.shared.market.command.SetUpInnerCouponCommand;
import com.gogirl.shared.market.command.SetUpOuterCouponCommand;

public interface MarketService {

    /**
     * 设置内部券
     *
     * @param cmd
     */
    void setUpInnerCoupon(SetUpInnerCouponCommand cmd);

    /**
     * 设置外部券
     *
     * @param cmd
     */
    void setUpOuterCoupon(SetUpOuterCouponCommand cmd);

    /**
     * 使用次卡
     *
     * @param cmd
     */
    void setTimesCard(SetTimesCardCommand cmd);

    /**
     * 更新订单卡券状态已使用
     *
     * @param orderId
     */
    void setterOrderMarket(Integer orderId);

    /**
     * 结算订单
     *
     * @param orderId
     */
    void setterOrder(Integer orderId);
}
