package com.gogirl.interfaces.store.training;


import com.gogirl.application.store.training.ITrainingFeedbackService;
import com.gogirl.application.store.training.ITrainingQuestionService;
import com.gogirl.domain.store.training.TrainingFeedback;
import com.gogirl.domain.store.training.TrainingQuestion;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-07-07
 */
@Api(tags = "美甲师培训反馈接口")
@RestController
public class TrainingFeedbackController {

    @Resource
    private ITrainingFeedbackService trainingFeedbackService;
    @Resource
    ITrainingQuestionService trainingQuestionService;


    @ApiOperation("提交培训反馈")
    @PostMapping("/technician/trainingFeedback/submitTrainingFeedBack")
    public JsonResult<Void> submitTrainingFeedBack(@RequestBody TrainingFeedback trainingFeedback) {
        trainingFeedbackService.submitTrainingFeedBack(trainingFeedback);
        return JsonResult.success();
    }

    @ApiOperation("是否有培训反馈需要填写")
    @GetMapping("/technician/trainingFeedback/hasFeedBackToDo")
    public JsonResult<Boolean> hasFeedBackToDo() {
        Boolean b = trainingFeedbackService.hasFeedBackToDo(SessionUtils.getTechnicianId());
        return JsonResult.success(b);
    }

    @ApiOperation("查询培训反馈问卷调查问题")
    @GetMapping("/technician/trainingQuestion/trainingFeedbackQuestions")
    public JsonResult<List<TrainingQuestion>> trainingFeedbackQuestions() {
        List<TrainingQuestion> trainingQuestionList = trainingQuestionService.trainingFeedbackQuestions();
        return JsonResult.success(trainingQuestionList);
    }

}
