package com.gogirl.application.product.serve.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.serve.IColorSystemService;
import com.gogirl.domain.product.serve.ColorSystem;
import com.gogirl.infrastructure.mapper.product.serve.ColorSystemMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 色系 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-03-09
 */
@Service
public class ColorSystemServiceImpl extends ServiceImpl<ColorSystemMapper, ColorSystem> implements IColorSystemService {

    @Resource
    ColorSystemMapper colorSystemMapper;

    @Override
    public List<ColorSystem> query(Integer id) {

        if (id == 0) {
            return this.list(new LambdaQueryWrapper<ColorSystem>()
                    .eq(ColorSystem::getPid, id));
        }
        return colorSystemMapper.listByPid(id);
    }
}
