package com.gogirl.infrastructure.common.config.property;


import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author robbendev
 */
@Component
@ConfigurationProperties(prefix = "wechat")
@Data
public class WxProperties {
    /**
     * 微信公众号
     */
    public String mpAppId;
    public String mpSecret;

    /**
     * 用户端gogirl小程序
     */
    public String customerMiniAppId;
    public String customerMiniSecret;
    /**
     * 店员端gogirl小程序
     */
    public String storeMiniAppId;
    public String storeMiniSecret;

    /**
     * 预约提醒订阅消息模板id
     */
    private String scheduleTpl;

    /**
     * 预约过期订阅消息模板id
     */
    private String overScheduleTpl;
    /**
     * 支付成功订阅消息模板id
     */
    private String paySuccessTpl;

    /**
     * 订单支付订阅消息模板id
     */
    private String orderPayNotifyTpl;

    /**
     * 问卷调查消息模版
     */
    public String testPaperTpl;

    /**
     * 店铺预约小程序订阅消息模版
     */
    private String shopScheduleTpl;

    /**
     * 店铺预约超时小程序消息模版
     */
    private String shopOverScheduleTpl;

    /**
     * 用户取消店铺小程序订阅消息模版
     */
    private String shopCancelScheduleTpl;
}
