package com.gogirl.infrastructure.mapper.order.serve;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.domain.order.serve.ScheduleManage;
import com.gogirl.domain.order.serve.ScheduleServe;
import com.gogirl.shared.product.LeisureScheduleServeResp;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * Created by yinyong on 2018/9/28.
 */

public interface ScheduleManageMapper extends BaseMapper<ScheduleManage> {


    List<ScheduleServe> listScheduleServeNotContainOrderId(@Param("startDateTime") String startDateTime, @Param("endDateTime") String endDateTime, @Param("departmentId") Integer departmentId, @Param("orderId") Integer orderId);

    List<ScheduleManage> selectArriveTimeBeforeOneHour();

    List<ScheduleServe> selectByScheduleId(Integer id);

    ScheduleManage lastOfDay();

    List<ScheduleManage> selectUnFinish(Integer technicianId);

    /**
     * 查询与时间冲突的服务
     *
     * @param startTime
     * @param endTime
     * @param technicianId
     * @param scheduleId
     * @return
     */
    List<ScheduleServe> checkConflict(@Param("startTime") Date startTime,
                                      @Param("endTime") Date endTime,
                                      @Param("technicianId") Integer technicianId,
                                      @Param("scheduleId") Integer scheduleId);

    /**
     * 闲时预约列表
     *
     * @param page
     * @return
     */
    IPage<LeisureScheduleServeResp> queryPageLeisureScheduleServe(IPage<LeisureScheduleServeResp> page,
                                                                  @Param("latitude") Double latitude,
                                                                  @Param("longitude") Double longitude,
                                                                  @Param("labelIdList") List<Integer> customerId);

}
