package com.gogirl.infrastructure.common.filter;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.stereotype.Component;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import java.io.IOException;

/**
 * 日志traceId
 *
 * @author robbendev
 */
@Component
@ServletComponentScan
@WebFilter(urlPatterns = {"/customer/*", "/technician/*"}, filterName = "requestLogFilter")
public class RequestLogFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setAttribute("logTraceId", IdWorker.getIdStr());
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {

    }
}
