package com.gogirl.shared.order.purchase.command;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SubmitPurchaseOrderCommand {


    private Integer id;

    @ApiModelProperty(value = "商品sku编号")
    private String sku;

    @ApiModelProperty(value = "没有关联sku前,店员填的商品名字")
    private String orderName;

    @ApiModelProperty(value = "订单创建人")
    private Integer creater;

    @ApiModelProperty(value = "该订单的采购单价")
    private BigDecimal price;

    @ApiModelProperty(value = "采购数量")
    private Integer quantity;

    @ApiModelProperty(value = "发起采购的店铺")
    private Integer createDepartmentId;

    @ApiModelProperty(value = "采购寄到哪个店铺id")
    private Integer departmentId;

    @ApiModelProperty(value = "创建采购时的备注")
    private String createRemark;

    @ApiModelProperty("图片路径,用逗号隔开多张图片")
    private String skuPicturePath;

    @ApiModelProperty("商品名字")
    private String skuName;

    @ApiModelProperty("商品类型")
    private Integer skuTypeName;

}
