package com.gogirl.infrastructure.common.util.thread;

/**
 * @author JXQ
 * @date 2019-04-10 14:14
 */
public class ThreadLocalUtil {

    /**
     * apiPath本地线程变量
     */
    private static ThreadLocal<String> apiPathThreadLocal;

    private static ThreadLocal<String> sqlConfigThreadLocal;

    /**
     * 存储projectId，appId
     */
    private static ThreadLocal<String> projectIdThreadLocal;
    private static ThreadLocal<String> appIdThreadLocal;

    /**
     * 获取apiPath本地线程变量值
     *
     * @return
     */
    public static String getApiPath() {
        return apiPathThreadLocal != null ? apiPathThreadLocal.get() : null;
    }

    /**
     * 设置值到apiPath本地线程变量中
     *
     * @param value
     */
    public static void setApiPath(String value) {
        if (apiPathThreadLocal == null) {
            apiPathThreadLocal = new InheritableThreadLocal();
        }

        apiPathThreadLocal.set(value);
    }

    /**
     * 获取sql本地线程变量值
     *
     * @return
     */
    public static String getSqlConfig() {
        return sqlConfigThreadLocal != null ? sqlConfigThreadLocal.get() : null;
    }

    /**
     * 设置值到sql本地线程变量中
     *
     * @param value
     */
    public static void setSqlConfig(String value) {
        if (sqlConfigThreadLocal == null) {
            sqlConfigThreadLocal = new InheritableThreadLocal();
        }

        sqlConfigThreadLocal.set(value);
    }

    /**
     * 获取projectId本地线程变量值
     *
     * @return
     */
    public static String getProjectId() {
        return projectIdThreadLocal != null ? projectIdThreadLocal.get() : null;
    }

    /**
     * 设置值到projectId本地线程变量中
     *
     * @param value
     */
    public static void setProjectId(String value) {
        if (projectIdThreadLocal == null) {
            projectIdThreadLocal = new InheritableThreadLocal();
        }

        projectIdThreadLocal.set(value);
    }

    /**
     * 获取appId本地线程变量值
     *
     * @return
     */
    public static String getAppId() {
        return appIdThreadLocal != null ? appIdThreadLocal.get() : null;
    }

    /**
     * 设置值到sql本地线程变量中
     *
     * @param value
     */
    public static void setAppId(String value) {
        if (appIdThreadLocal == null) {
            appIdThreadLocal = new InheritableThreadLocal();
        }

        appIdThreadLocal.set(value);
    }

    /**
     * 移除apiPath本地线程变量中的值
     */
    public static void removeApiPath() {
        if (apiPathThreadLocal != null) {
            apiPathThreadLocal.remove();
        }
    }

    /**
     * 移除sql本地线程变量中的值
     */
    public static void removeSqlConfig() {
        if (sqlConfigThreadLocal != null) {
            sqlConfigThreadLocal.remove();
        }
    }

    /**
     * 移除projectId本地线程变量中的值
     */
    public static void removeProjectId() {
        if (projectIdThreadLocal != null) {
            projectIdThreadLocal.remove();
        }
    }

    /**
     * 移除appId本地线程变量中的值
     */
    public static void removeAppId() {
        if (appIdThreadLocal != null) {
            appIdThreadLocal.remove();
        }
    }

    /**
     * 移除projectId、appId
     */
    public static void removeProjectIdAndAppId() {
        removeProjectId();
        removeAppId();
    }
}
