package com.gogirl.application.xcx.impl;

import com.github.binarywang.utils.qrcode.MatrixToImageWriter;
import com.gogirl.application.xcx.QRCodeService;
import com.gogirl.infrastructure.config.property.GogirlProperties;
import com.gogirl.infrastructure.service.file.FileService;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;
import java.util.UUID;


@Service
@Slf4j
public class QRCodeServiceImpl implements QRCodeService {

    @Resource
    private GogirlProperties gogirlProperties;
    @Resource
    FileService fileService;

    public String myQrCode(String customerId, String phone) throws Exception {

        //定义二维码文件名，采用uuid命名，存储格式为png
        String QRCodeName = UUID.randomUUID().toString().replaceAll("-", "");

        JSONObject map = new JSONObject();
        map.put("customerId", customerId);
        map.put("phone", phone);

        QRCodeWriter qrCodeWriter = new QRCodeWriter();

        BitMatrix bitMatrix = qrCodeWriter.encode(map.toString(), BarcodeFormat.QR_CODE, 350, 350);

        File file = new File(gogirlProperties.getPicturePath() + QRCodeName);

        MatrixToImageWriter.writeToFile(bitMatrix, "PNG", file);

        return fileService.qiniuUpload(file);
    }

}


