package com.gogirl.application.product.mall.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.product.mall.MallShoppingCartCmdService;
import com.gogirl.assembler.MallShoppingCartAssembler;
import com.gogirl.domain.order.mall.MallShoppingCart;
import com.gogirl.infrastructure.mapper.order.mall.MallShoppingCartMapper;
import com.gogirl.shared.product.command.DecreaseCartCommand;
import com.gogirl.shared.product.command.MallShoppingCartCommand;
import com.gogirl.shared.product.command.RemoveAllCartCommand;
import com.gogirl.shared.product.command.RemoveCartCommand;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.security.InvalidParameterException;

@Service
@AllArgsConstructor
public class MallShoppingCartCmdServiceImpl implements MallShoppingCartCmdService {


    private final MallShoppingCartMapper mallShoppingCartMapper;

    private final MallShoppingCartAssembler mallShoppingCartAssembler;

    @Override
    public void addMallShoppingCart(MallShoppingCartCommand cmd) {

        MallShoppingCart mallShoppingCart = mallShoppingCartAssembler.apply(cmd);
        mallShoppingCart.setCreateTime(System.currentTimeMillis());

        MallShoppingCart oldMallShoppingCart = mallShoppingCartMapper
                .selectOne(new LambdaQueryWrapper<MallShoppingCart>()
                        .eq(MallShoppingCart::getCustomerId, cmd.getCustomerId())
                        .eq(MallShoppingCart::getProductId, cmd.getProductId()));

        //加数量
        if (oldMallShoppingCart != null) {
            oldMallShoppingCart.setLastUpdateTime(System.currentTimeMillis());
            oldMallShoppingCart.setNum(oldMallShoppingCart.getNum() + mallShoppingCart.getNum());
            mallShoppingCartMapper.updateById(oldMallShoppingCart);
        }
        //新的购物车项
        else {
            mallShoppingCart.setCreateTime(System.currentTimeMillis());
            mallShoppingCartMapper.insert(mallShoppingCart);
        }
    }

    @Override
    public void removeAllMallShoppingCart(RemoveAllCartCommand cmd) {
        if (cmd.getCustomerId() == null) {
            throw new InvalidParameterException();
        }
        mallShoppingCartMapper
                .delete(new LambdaQueryWrapper<MallShoppingCart>().eq(MallShoppingCart::getCustomerId, cmd.getCustomerId()));
    }

    @Override
    public void removeMallShoppingCart(RemoveCartCommand cmd) {
        mallShoppingCartMapper.deleteById(cmd.getId());
    }

    @Override
    public void decreaseMallShoppingCart(DecreaseCartCommand cmd) {

        MallShoppingCart mallShoppingCart = mallShoppingCartMapper
                .selectOne(new LambdaQueryWrapper<MallShoppingCart>()
                        .eq(MallShoppingCart::getCustomerId, cmd.getCurrentCustomerId())
                        .eq(MallShoppingCart::getProductId, cmd.getProductId()));

        if (mallShoppingCart != null) {
            if (mallShoppingCart.getNum() > 1) {
                mallShoppingCart.setNum((mallShoppingCart.getNum() - 1));
                mallShoppingCartMapper.updateById(mallShoppingCart);
            }
            //移除购物车项
            else {
                mallShoppingCartMapper.deleteById(mallShoppingCart.getId());
            }
        }
    }
}
