package com.gogirl.application.order.mall;

import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.order.mall.MallCustomerAddress;

import java.util.List;

public interface MallCustomerAddressService extends IService<MallCustomerAddress> {

    /**
     * 新增收货地址
     *
     * @param mallCustomerAddress 收货地址
     */
    void addMallCustomerAddress(MallCustomerAddress mallCustomerAddress);


    /**
     * 获取默认收货地址 如果没有收货地址则返回随机收货地址
     *
     * @param currentCustomerId 当前登陆顾客id
     * @return
     */
    MallCustomerAddress getDefaultMallCustomerAddress(Integer currentCustomerId);

    /**
     * 修改默认收货地址
     *
     * @param currentCustomerId
     * @param mallCustomerAddressId
     * @return 默认收货地址对象
     */
    MallCustomerAddress updateDefaultMallCustomerAddress(Integer currentCustomerId, Long mallCustomerAddressId);

    /**
     * 我的收货地址列表
     *
     * @param currentCustomerId
     * @return
     */
    List<MallCustomerAddress> listMallCustomerAddress(Integer currentCustomerId);

    /**
     * 修改收货地址
     *
     * @param mallCustomerAddress
     */
    void changeMallCustomerAddress(MallCustomerAddress mallCustomerAddress);
}
