package com.gogirl.infrastructure.common.exception;


import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.service.mail.MailService;
import com.gogirl.infrastructure.util.ParamsUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * 统一异常处理器
 *
 * @author robbendev
 */
@ControllerAdvice
@ResponseBody
@Slf4j
public class RRExceptionHandler {

    @Value("${spring.profiles.active}")
    private String profile;

    @Resource
    MailService mailService;

    /**
     * 自定义异常
     */
    @ExceptionHandler(RRException.class)
    public JsonResult<String> handleRRException(HttpServletRequest request,
                                                RRException e) {
        JsonResult<String> result = new JsonResult<>();
        result.setSuccess(false);
        result.setCode(e.getCode());
        result.setMessage(e.getMessage());

        log.error(e.getMessage());
        return result;
    }

    /**
     * 未捕获异常
     */
    @ExceptionHandler(Exception.class)
    public JsonResult<String> handleException(HttpServletRequest request,
                                              Exception e) {
        JsonResult<String> result = new JsonResult<>();
        result.setSuccess(false);
        result.setCode(500);
        result.setMessage(e.getMessage());

        //输出日志
        this.log(e, request);

        //错误邮件内容
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);

        //发送邮件
        if (profile.equals("prod"))
            mailService.sendSimpleMail("robbendev@qq.com", profile + "异常", sw.toString());

        return result;
    }


    private void log(Exception ex, HttpServletRequest request) {
        log.error("************************异常开始*******************************");
        log.error("params:" + ParamsUtils.getParams());
        log.error(ex.getMessage(), ex);
        log.error("************************异常结束*******************************");
    }
}
