package com.gogirl.application.market.coupon;

import com.gogirl.shared.market.SetTimesCardCommand;
import com.gogirl.shared.market.SetUpInnerCouponCommand;
import com.gogirl.shared.market.SetUpOuterCouponCommand;

public interface MarketService {

    /**
     * 预约订单使用内部券
     *
     * @param cmd
     */
    void setUpInnerCoupon(SetUpInnerCouponCommand cmd);

    /**
     * 预约订单使用外部券
     *
     * @param cmd
     */
    void setUpOuterCoupon(SetUpOuterCouponCommand cmd);

    /**
     * 预约使用次卡
     *
     * @param cmd
     */
    void setTimesCard(SetTimesCardCommand cmd);

    /**
     * 预约订单完成支付
     * <p>
     * 订单支付完成后调用这个方法更新订单关联的卡券状态
     * </p>
     *
     * @param orderId
     */
    void finishPayOrder(Integer orderId);

    /**
     * 计算订单金额
     * <p>
     * 使用卡券次卡使用使用该方法计算订单的实际金额和折扣金额并持久到数据库
     * </p>
     *
     * @param orderId
     */
    void calcOrderAmount(Integer orderId);
}
