package com.gogirl.interfaces.store.training;


import com.gogirl.application.store.training.ITrainingFeedbackService;
import com.gogirl.domain.store.training.TrainingFeedback;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.util.SessionUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-07-07
 */
@RestController
@RequestMapping("/technician/trainingFeedback")
public class TrainingFeedbackController {

    @Resource
    private ITrainingFeedbackService trainingFeedbackService;

    @PostMapping("/submitTrainingFeedBack")
    public JsonResult<Void> submitTrainingFeedBack(@RequestBody TrainingFeedback trainingFeedback) {
        trainingFeedbackService.submitTrainingFeedBack(trainingFeedback);
        return JsonResult.success();
    }

    @GetMapping("/hasFeedBackToDo")
    public JsonResult<Boolean> hasFeedBackToDo() {
        Boolean b = trainingFeedbackService.hasFeedBackToDo(SessionUtils.getTechnicianId());
        return JsonResult.success(b);
    }
}
