package com.gogirl.domain.store.training;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@TableName("training_course")
public class TrainingCourse implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("课程分类")
    private Integer typeId;

    @ApiModelProperty("课程名称")
    private String name;

    @ApiModelProperty("课程sku")
    private String no;

    @ApiModelProperty("能力对象")
    private String object;

    @ApiModelProperty("展示内容")
    private String content;

    @TableField(value = "`describe`")
    @ApiModelProperty("课程简述")
    private String describe;

    @ApiModelProperty("教材文件路径")
    private String teachingMaterialPath;

    @ApiModelProperty("实操性")
    private String practicality;

    @ApiModelProperty("课程时长，分钟")
    private String duration;

    @ApiModelProperty("课程优势")
    private String advantage;
}

