package com.gogirl.application.market.discount.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.market.discount.DiscountConfigService;
import com.gogirl.domain.market.discount.DiscountConfig;
import com.gogirl.infrastructure.mapper.market.discount.DiscountConfigMapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
@Slf4j
public class DiscountConfigServiceImpl extends ServiceImpl<DiscountConfigMapper, DiscountConfig> implements DiscountConfigService {

    private final DiscountConfigMapper discountConfigDao;


    @Override
    public List<DiscountConfig> selectAllDiscount() {
        return discountConfigDao.selectAllDiscount();
    }

    @Override
    public DiscountConfig selectByCharge(int amount) {
        return discountConfigDao.selectByCharge(amount);
    }
}
