package com.gogirl.application.product.mall;

import com.gogirl.shared.product.command.DecreaseCartCommand;
import com.gogirl.shared.product.command.MallShoppingCartCommand;
import com.gogirl.shared.product.command.RemoveAllCartCommand;
import com.gogirl.shared.product.command.RemoveCartCommand;

public interface MallShoppingCartCmdService {

    /**
     * 减少购物车项数量
     *
     * @param cmd cmd
     */
    void decreaseMallShoppingCart(DecreaseCartCommand cmd);

    /**
     * 删除购物车项
     *
     * @param cmd cmd
     */
    void removeMallShoppingCart(RemoveCartCommand cmd);

    /**
     * 清空购物车
     *
     * @param cmd cmd
     */
    void removeAllMallShoppingCart(RemoveAllCartCommand cmd);


    /**
     * 新增购物车
     *
     * @param cmd cmd
     */
    void addMallShoppingCart(MallShoppingCartCommand cmd);
}
