package com.gogirl.infrastructure.interceptor;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.user.customer.CustomerService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.user.Customer;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.mapper.store.StoreManageMapper;
import com.gogirl.infrastructure.mapper.store.StoreTechnicianMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Component
@AllArgsConstructor
@Slf4j
public class SessionHandlerInterceptor implements HandlerInterceptor {

    private final GogirlTokenService gogirlTokenService;
    private final CustomerService customerService;

    private final StoreTechnicianMapper storeTechnicianMapper;
    private final StoreManageMapper storeManageMapper;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

        String token = request.getHeader("token");

        String sourceFrom = request.getHeader("sourceFrom");
        if (sourceFrom == null) {
            return true;
        }
        if (sourceFrom.equals("customer")) {
            GogirlToken gogirlToken = gogirlTokenService.getOne(new LambdaQueryWrapper<GogirlToken>().eq(GogirlToken::getToken, token));
            if (gogirlToken != null) {
                Customer customer = customerService.getById(gogirlToken.getCustomerId());
                SessionUtils.putCustomer(customer);
            }
        }
        if (sourceFrom.equals("technician")) {
            GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
            if (gogirlToken != null) {
                StoreTechnician storeTechnician = storeTechnicianMapper.selectById(gogirlToken.getTechnicianId());
                storeTechnician.setTechnicianId(storeTechnician.getId());
                storeTechnician.setDepartmentId(gogirlToken.getDepartmentId());
                SessionUtils.putStoreTechnician(storeTechnician);
            }
        }
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        SessionUtils.removeCustomer();
        SessionUtils.removeStoreTechnician();
    }

}
