package com.gogirl.infrastructure.mapper.order.serve;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gogirl.domain.order.serve.ScheduleServe;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

public interface ScheduleServeMapper extends BaseMapper<ScheduleServe> {

    List<ScheduleServe> selectConflictType(@Param("scheduledUser") Integer scheduledUser,
                                           @Param("days") Date days,
                                           @Param("schTypeId") Integer schTypeId,
                                           @Param("scheduleId") Integer scheduleId);

    /**
     * 更新服务状态需要更新的预约服务列表
     *
     * @param schId
     * @param serveId
     * @return
     */
    List<ScheduleServe> selectUpdateStatusList(@Param("schId") Integer schId, @Param("serveId") Integer serveId);


    /**
     * 服务的卸甲子服务
     *
     * @param mainServeId
     * @return
     */
    ScheduleServe subRemoveArmor(@Param("mainServeId") Integer mainServeId, @Param("scheduleId") Integer scheduleId);

    /**
     * 服务的延长子服务
     *
     * @param mainServeId
     * @param scheduleId
     * @return
     */

    ScheduleServe subExtend(@Param("mainServeId") Integer mainServeId, @Param("scheduleId") Integer scheduleId);

}
