package com.gogirl.domain.order.mall;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

@ApiModel("商城退款订单")
@Data
@TableName("mall_refund_order")
@Builder
@AllArgsConstructor
public class MallRefundOrder {


    public static final Integer STATUS_REFUNDING = 1;
    public static final Integer STATUS_REFUNDED = 2;
    @TableId(type = IdType.ID_WORKER)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    @ApiModelProperty("商城购买订单id")
    private Long mallOrderId;
    @ApiModelProperty("顾客id")
    private Integer customerId;
    @ApiModelProperty("发起退款时间")
    private Long refundTime;
    @ApiModelProperty("退款联系人姓名")
    private String refundContactName;
    @ApiModelProperty("退款联系人手机号")
    private String refundContactPhone;
    @ApiModelProperty("退款原因")
    private String refundReason;
    @ApiModelProperty("订单总金额")
    private BigDecimal refundTotalAmount;
    @ApiModelProperty("退款单状态 1-退款中 2-已退款")
    private Integer status;
    @TableField(exist = false)
    @ApiModelProperty("订单详情")
    private List<MallRefundOrderDetail> mallOrderDetailList;

    /**
     * 根据订单构建全额退款订单对象
     *
     * @param mallOrder 需要退款的订单
     */
    public void buildMallRefundOrderAggregate(MallOrder mallOrder) {

        //todo 扩展部分退款 数量和订单详情的支付金额来计算
        this.setMallOrderDetailList(mallOrder.getMallOrderDetailList()
                .stream()
                .map(mallOrderDetail -> {
                    MallRefundOrderDetail mallRefundOrderDetail = new MallRefundOrderDetail();
                    //退款详情退款金额
                    mallRefundOrderDetail.setAmount(mallOrderDetail.getPayAmount());
                    //退款详情关联的订单详情id
                    mallRefundOrderDetail.setMallOrderDetailId(mallOrderDetail.getId());
                    //退款详情关联的订单详情id
                    mallRefundOrderDetail.setRefundNum(mallOrderDetail.getNum());
                    return mallRefundOrderDetail;
                })
                .collect(Collectors.toList()));


        //设置退款时间
        this.setRefundTime(System.currentTimeMillis());
        //设置退款时间
        this.setRefundTotalAmount(mallOrder.getTotalPayAmount());
        //设置退款金额
        this.setMallOrderId(mallOrder.getId());
        //退款单状态 -退款中
        this.setStatus(MallRefundOrder.STATUS_REFUNDING);

    }

}
