package com.gogirl.application.market.coupon.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.gogirl.application.market.coupon.CouponCustomerRelevanceService;
import com.gogirl.application.market.coupon.CouponOrderRelevanceService;
import com.gogirl.application.market.coupon.CouponService;
import com.gogirl.application.market.coupon.MarketService;
import com.gogirl.application.market.timescard.TimesCardCustomerRelevanceService;
import com.gogirl.application.market.timescard.TimesCardUsedRecordService;
import com.gogirl.application.order.market.ICouponOrderService;
import com.gogirl.application.order.serve.OrderServeService;
import com.gogirl.domain.market.coupon.Coupon;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;
import com.gogirl.domain.market.coupon.CouponOrderRelevance;
import com.gogirl.domain.market.discount.DiscountConfig;
import com.gogirl.domain.market.timescard.TimesCardCustomerRelevance;
import com.gogirl.domain.market.timescard.TimesCardOrderServeDetail;
import com.gogirl.domain.market.timescard.TimesCardUsedRecord;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.market.coupon.CouponCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.market.coupon.CouponMapper;
import com.gogirl.infrastructure.mapper.market.discount.DiscountConfigMapper;
import com.gogirl.infrastructure.mapper.market.timescard.TimesCardCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.market.timescard.TimesCardOrderServeDetailMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderServeMapper;
import com.gogirl.shared.market.SetTimesCardCommand;
import com.gogirl.shared.market.SetUpInnerCouponCommand;
import com.gogirl.shared.market.SetUpOuterCouponCommand;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.security.InvalidParameterException;
import java.util.*;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@Service
@Slf4j
public class MarketServiceImpl implements MarketService {

    @Resource
    @Lazy
    TimesCardOrderServeDetailMapper timesCardOrderServeDetailMapper;

    @Resource
    @Lazy
    private CouponMapper couponMapper;

    @Resource
    @Lazy
    private CouponCustomerRelevanceService couponCustomerRelevanceService;

    @Resource
    @Lazy
    private CouponOrderRelevanceService couponOrderRelevanceService;

    @Resource
    @Lazy
    private OrderManageMapper orderManageMapper;

    @Lazy
    @Resource
    private OrderServeMapper orderServeMapper;

    @Lazy
    @Resource
    private TimesCardCustomerRelevanceMapper timesCardCustomerRelevanceMapper;

    @Lazy
    @Resource
    private CouponCustomerRelevanceMapper couponCustomerRelevanceMapper;

    @Lazy
    @Resource
    private OrderServeService orderServeService;

    @Lazy
    @Resource
    private TimesCardUsedRecordService timesCardUsedRecordService;

    @Lazy
    @Resource
    private TimesCardCustomerRelevanceService timesCardCustomerRelevanceService;

    @Lazy
    @Resource
    private DiscountConfigMapper discountConfigMapper;

    @Lazy
    @Resource
    ICouponOrderService couponOrderService;

    @Resource
    CouponService couponService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void setUpInnerCoupon(SetUpInnerCouponCommand cmd) {

        if (cmd.getOrderId() == null) {
            throw new InvalidParameterException();
        }

        /*1、将订单之前绑定的内部券设置为未使用*/
        List<CouponCustomerRelevance> setCouponCustomerRelevanceList = couponCustomerRelevanceService.list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                .eq(CouponCustomerRelevance::getOrderId, cmd.getOrderId())
                .eq(CouponCustomerRelevance::getSourceType, CouponCustomerRelevance.SOURCE_TYPE_INNER));

        setCouponCustomerRelevanceList.forEach(couponCustomerRelevance -> {
            //订单id设置为空
            couponCustomerRelevance.setOrderId(null);
            //卡券状态 可使用
            couponCustomerRelevance.setState(1);
            couponCustomerRelevanceMapper.updateById(couponCustomerRelevance);
        });

        if (ListUtil.isNotEmpty(setCouponCustomerRelevanceList)) {

            //删除这些卡券对应的卡券订单折扣详情
            couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
                    .eq(CouponOrderRelevance::getOrderId, cmd.getOrderId())
                    .in(CouponOrderRelevance::getCouponCustomerRelevanceId, setCouponCustomerRelevanceList.stream().map(CouponCustomerRelevance::getId).collect(Collectors.toList())));

        }

        /*2、设置卡券关联*/
        if (ListUtil.isNotEmpty(cmd.getInnerCouponCustomerRelevanceIds())) {
            List<CouponCustomerRelevance> couponCustomerRelevanceList = (List<CouponCustomerRelevance>) couponCustomerRelevanceService
                    .listByIds(cmd.getInnerCouponCustomerRelevanceIds());


            if (ListUtil.isNotEmpty(couponCustomerRelevanceList)) {
                couponCustomerRelevanceList.forEach(couponCustomerRelevance -> {
                    Integer usedOrderId = couponCustomerRelevance.getOrderId();


                    couponCustomerRelevance.setOrderId(cmd.getOrderId());
                    //选择使用
                    couponCustomerRelevance.setState(CouponCustomerRelevance.STATE_CHOSE);
                    couponCustomerRelevanceMapper.updateById(couponCustomerRelevance);

                    if (usedOrderId != null) {
                        this.calcOrderAmount(usedOrderId);

                        //删除这些卡券对应的卡券订单折扣详情
                        couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
                                .eq(CouponOrderRelevance::getOrderId, usedOrderId)
                                .eq(CouponOrderRelevance::getCouponCustomerRelevanceId, couponCustomerRelevance.getId()));


                    }
                });
            }

            couponService.checkCouponConflict(couponCustomerRelevanceMapper.selectList(new LambdaQueryWrapper<CouponCustomerRelevance>()
                    .eq(CouponCustomerRelevance::getOrderId, cmd.getOrderId())
                    .eq(CouponCustomerRelevance::getState, CouponCustomerRelevance.STATE_CHOSE))
                    .stream()
                    .map(CouponCustomerRelevance::getCouponId)
                    .collect(Collectors.toList()));

        }
    }

    @Override
    public void setUpOuterCoupon(SetUpOuterCouponCommand cmd) {

        if (cmd.getOrderId() == null) {
            throw new InvalidParameterException();
        }
        //删除订单的外部卡券关联
        couponCustomerRelevanceService.remove(
                new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, cmd.getOrderId())
                        .eq(CouponCustomerRelevance::getSourceType, CouponCustomerRelevance.SOURCE_TYPE_OUTER)
        );


        cmd.getOuterCouponIds().forEach(outerCouponId -> {
            Coupon coupon = couponMapper.selectById(outerCouponId);

            //根据卡券类型发一张券并且设置状态 已选择
            CouponCustomerRelevance couponCustomerRelevance = CouponCustomerRelevance.getInstance(coupon);
            couponCustomerRelevance.setOrderId(cmd.getOrderId());
            couponCustomerRelevance.setCustomerId(cmd.getCustomerId());
            //选择
            couponCustomerRelevance.setState(CouponCustomerRelevance.STATE_CHOSE);

            if (!couponCustomerRelevance.isValid()) {
                throw new RRException("卡券过期");
            }
            couponCustomerRelevanceService.save(couponCustomerRelevance);
        });

        couponService.checkCouponConflict(couponCustomerRelevanceMapper.selectList(new LambdaQueryWrapper<CouponCustomerRelevance>()
                .eq(CouponCustomerRelevance::getOrderId, cmd.getOrderId())
                .eq(CouponCustomerRelevance::getState, CouponCustomerRelevance.STATE_CHOSE))
                .stream()
                .map(CouponCustomerRelevance::getCouponId)
                .collect(Collectors.toList()));

    }

    @Override
    public void setTimesCard(SetTimesCardCommand cmd) {

        if (cmd.getOrderId() == null) {
            throw new InvalidParameterException();
        }
        //删除订单已经绑定的次卡
        List<TimesCardUsedRecord> removeTimesCardUsedRecordList = timesCardUsedRecordService.list(
                new LambdaQueryWrapper<TimesCardUsedRecord>()
                        .eq(TimesCardUsedRecord::getOrderId, cmd.getOrderId()));
        removeTimesCardUsedRecordList.forEach(timesCardUsedRecord -> {
            TimesCardCustomerRelevance timesCardCustomerRelevance = timesCardCustomerRelevanceMapper.selectById(timesCardUsedRecord.getCardRelevanceCustomerId());
            timesCardCustomerRelevance.setUsedTimes(timesCardCustomerRelevance.getUsedTimes() - 1);
            timesCardCustomerRelevanceMapper.updateById(timesCardCustomerRelevance);
            timesCardUsedRecordService.removeById(timesCardUsedRecord.getId());
        });

        cmd.getTimesCardIds().forEach(id -> {
            //用户次卡
            TimesCardCustomerRelevance cardCustomerRelevance = timesCardCustomerRelevanceService.getById(id);
            //当前次卡所有使用记录
            List<TimesCardUsedRecord> timesCardUsedRecordList = timesCardUsedRecordService.list(
                    new LambdaQueryWrapper<TimesCardUsedRecord>().eq(TimesCardUsedRecord::getCardRelevanceCustomerId, cardCustomerRelevance.getId()));

            //如果次卡已使用记录等于次卡总次数
            if (timesCardUsedRecordList
                    .stream()
                    .filter(record -> record.getStatus().equals(TimesCardUsedRecord.STATUS_USED))
                    .count() == cardCustomerRelevance.getSumTimes()) {
                throw new RRException("次卡已经用完");
            }

            //如果次卡还有未绑定的次数就新建关联
            if (cardCustomerRelevance.getSumTimes() > timesCardUsedRecordList.size()) {
                TimesCardUsedRecord timesCardUsedRecord = TimesCardUsedRecord.builder()
                        //订单id
                        .orderId(cmd.getOrderId())
                        //次卡类型id
                        .cardTypeId(cardCustomerRelevance.getCardTypeId())
                        //次卡名称
                        .name(cardCustomerRelevance.getName())
                        //次卡id
                        .cardRelevanceCustomerId(cardCustomerRelevance.getId())
                        //绑定时间
                        .time(new Date())
                        //选择使用
                        .status(TimesCardUsedRecord.STATUS_CHOSE)
                        //次卡用户id
                        .customerId(cardCustomerRelevance.getCustomerId())
                        //次卡当次能抵扣的金额
                        .discountAmount(cardCustomerRelevance.getDiscountAmount())
                        //次卡当次实际支付金额
                        .payAmount(cardCustomerRelevance.getPayAmount())
                        .type(1)
                        .build();

                //新增一条次卡选择使用记录
                timesCardUsedRecordService.save(timesCardUsedRecord);
            }
            //替换
            else {
                //从所有的次卡记录中过滤出一条次卡选择记录
                TimesCardUsedRecord timesCardUsedRecord = timesCardUsedRecordList
                        .stream()
                        .filter(record -> record.getStatus().equals(TimesCardUsedRecord.STATUS_CHOSE))
                        .findAny()
                        .orElseThrow(NullPointerException::new);

                //更新次卡选择记录对应的订单
                timesCardUsedRecord.setOrderId(cmd.getOrderId());
                timesCardUsedRecord.setTime(new Date());
                timesCardUsedRecordService.saveOrUpdate(timesCardUsedRecord);
            }
        });
    }

    @Override
    public void finishPayOrder(Integer orderId) {


        //订单使用的内部券
        List<CouponCustomerRelevance> innerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
                .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, orderId)
                        .eq(CouponCustomerRelevance::getState, 1)
                        .eq(CouponCustomerRelevance::getSourceType, 0));

        innerCouponCustomerRelevanceServiceList.forEach(couponCustomerRelevance -> couponCustomerRelevance.setState(CouponCustomerRelevance.STATE_USED));

        if (ListUtil.isNotEmpty(innerCouponCustomerRelevanceServiceList)) {
            couponCustomerRelevanceService.saveOrUpdateBatch(innerCouponCustomerRelevanceServiceList);

            //内部券一般没有订单产生，但还是
            couponOrderService.createOrder(innerCouponCustomerRelevanceServiceList);
        }

        //订单使用的外部券
        List<CouponCustomerRelevance> outerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
                .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, orderId)
                        .eq(CouponCustomerRelevance::getState, 1)
                        .eq(CouponCustomerRelevance::getSourceType, 1));
        outerCouponCustomerRelevanceServiceList.forEach(couponCustomerRelevance -> couponCustomerRelevance.setState(CouponCustomerRelevance.STATE_USED));
        if (ListUtil.isNotEmpty(outerCouponCustomerRelevanceServiceList)) {
            couponCustomerRelevanceService.saveOrUpdateBatch(outerCouponCustomerRelevanceServiceList);

            //外部券只有在使用之后才写入卡券订单(虚拟订单) 只写入支付金额>0的卡券
            couponOrderService.createOrder(outerCouponCustomerRelevanceServiceList);
        }


        //订单使用的次卡
        List<TimesCardUsedRecord> timesCardUsedRecordList = timesCardUsedRecordService
                .list(new LambdaQueryWrapper<TimesCardUsedRecord>()
                        .eq(TimesCardUsedRecord::getOrderId, orderId)
                        .eq(TimesCardUsedRecord::getStatus, 1));
        timesCardUsedRecordList.forEach(timesCardUsedRecord -> timesCardUsedRecord.setStatus(TimesCardUsedRecord.STATUS_USED));
        if (ListUtil.isNotEmpty(timesCardUsedRecordList)) {
            timesCardUsedRecordService.saveOrUpdateBatch(timesCardUsedRecordList);
            //更新使用次数
            TimesCardCustomerRelevance timesCardCustomerRelevance = timesCardCustomerRelevanceService.getById(timesCardUsedRecordList.stream().findAny().orElseThrow(NullPointerException::new).getCardRelevanceCustomerId());
            timesCardCustomerRelevance.setUsedTimes(timesCardCustomerRelevance.getUsedTimes() + 1);
            if (timesCardCustomerRelevance.getUsedTimes().equals(timesCardCustomerRelevance.getSumTimes())) {
                //次数用完
                timesCardCustomerRelevance.setStatus(2);
            }
            timesCardCustomerRelevanceService.updateById(timesCardCustomerRelevance);

        }
    }


    public void achievementReCalc(Integer orderId) {

        //订单使用的内部券
        List<CouponCustomerRelevance> innerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
                .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, orderId)
                        .eq(CouponCustomerRelevance::getState, 2)
                        .eq(CouponCustomerRelevance::getSourceType, 0));

        //订单使用的外部券
        List<CouponCustomerRelevance> outerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
                .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, orderId)
                        .eq(CouponCustomerRelevance::getState, 2)
                        .eq(CouponCustomerRelevance::getSourceType, 1));

        //订单使用的次卡
        List<TimesCardUsedRecord> timesCardUsedRecordList = timesCardUsedRecordService
                .list(new LambdaQueryWrapper<TimesCardUsedRecord>()
                        .eq(TimesCardUsedRecord::getOrderId, orderId)
                        .eq(TimesCardUsedRecord::getStatus, 2));

        //查询订单聚合
        OrderManage orderManage = orderManageMapper.selectById(orderId);
        List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, orderId));
        orderManage.setListOrderServer(orderServeList);

        //order serve 卡券绑定状态reset
        orderServeList.forEach(orderServe -> {
            orderServe.setBindInnerCoupon(2);
            orderServe.setBindTimesCard(2);
            orderServe.setBindOuterCoupon(2);
        });

        /*1、rest 订单未使用卡券状态*/
        //总支付金额等于 总价格+总改价 rest
        orderManage.setTotalPaymentAmount(orderManage.getTotalPrice().add(orderManage.getChangePrice()));

        //总折扣金额 rest0
        orderManage.setDiscountPrice(BigDecimal.ZERO);

        orderManage.getListOrderServer().forEach(orderServe -> {
            //reset 服务世纪支付金额 服务实际支付金额=服务价格+服务改价
            orderServe.setPayPrice(orderServe.getPrice().add(orderServe.getServeChangePrice()));
            //reset 服务折金额=0
            orderServe.setDiscountPrice(BigDecimal.ZERO);
            //reset 业绩 如果是贵族会员免费手部基础护理 或者 特级会员免费修手 业绩为10元 其他的是实际支付金额
            if (orderServe.getServeName().equals("贵族会员免费手部基础护理")
                    || orderServe.getServeName().equals("特级会员免费修手")) {
                orderServe.setAchievement(new BigDecimal(10).add(orderServe.getServeChangePrice()));
            } else {
                orderServe.setAchievement(orderServe.getPrice().add(orderServe.getServeChangePrice()));
            }
        });

        /*2、次卡*/
        if (ListUtil.isNotEmpty(timesCardUsedRecordList)) {
            //次卡使用记录
            timesCardUsedRecordList.forEach(timesCardUsedRecord -> timesCardUsedRecord.setStatus(TimesCardUsedRecord.STATUS_CHOSE));

            timesCardUsedRecordList.stream()
                    .sorted(Comparator.comparing(TimesCardUsedRecord::getDiscountAmount))
                    .forEach(timesCardUsedRecord -> {

//                        timesCardOrderServeDetailMapper.delete(new LambdaQueryWrapper<TimesCardOrderServeDetail>().eq(TimesCardOrderServeDetail::getOrderId, orderId));
                        //次卡能用的服务id
                        List<Integer> serveIds = timesCardCustomerRelevanceMapper.queryTimesCardServeIds(timesCardUsedRecord.getCardTypeId());
                        //抵扣的服务为 作用范围内支付金额最高的服务
                        OrderServe orderServe = this.queryMaxPayPrice(orderManage, serveIds);
                        if (orderServe != null) {

                            BigDecimal actualDiscountAmount = orderServe.getPayPrice().min(timesCardUsedRecord.getDiscountAmount());
//                            //更新次卡记录 已使用
//                            timesCardUsedRecord.setStatus(TimesCardUsedRecord.STATUS_USED);
                            //次卡对应订单服务的美甲师
                            timesCardUsedRecord.setTechnicianName(orderServe.getTechnicianName());
                            //次卡店铺名称
                            timesCardUsedRecord.setDepartmentName(orderManage.getDepartmentName());
                            //次卡店铺id
                            timesCardUsedRecord.setDepartmentId(orderManage.getDepartmentId());
                            //次卡折扣的
                            timesCardUsedRecord.setServeName(orderServe.getServeName());
                            //次卡作用的服务id
                            timesCardUsedRecord.setOrderServeId(orderServe.getServeId());
                            //次卡作用的订单id
                            timesCardUsedRecord.setOrderId(orderId);
                            //次卡实付金额
                            timesCardUsedRecord.setActualDiscountAmount(actualDiscountAmount);
//                            timesCardUsedRecordService.updateById(timesCardUsedRecord);

                            //在主服务上折扣的钱
                            TimesCardOrderServeDetail timesCardOrderServeDetail = new TimesCardOrderServeDetail();
                            timesCardOrderServeDetail.setDiscountAmount(actualDiscountAmount);
                            timesCardOrderServeDetail.setOrderServeId(orderServe.getId());
                            timesCardOrderServeDetail.setOrderId(orderId);
                            timesCardOrderServeDetail.setTimesCardUserRecordId(timesCardUsedRecord.getOrderServeId());
                            //业绩
                            timesCardOrderServeDetail.setAchievement(timesCardUsedRecord.getPayAmount());
//                            timesCardOrderServeDetailMapper.insert(timesCardOrderServeDetail);

                            //订单折扣金额更新
                            orderServe.setBindTimesCard(1);
                            orderServe.addDiscountPrice(actualDiscountAmount);

                            //业绩
                            orderServe.setAchievement(orderServe.getAchievement().subtract(actualDiscountAmount).add(timesCardUsedRecord.getPayAmount()));
                            orderManage.addDiscountPrice(actualDiscountAmount);
//
//                            //更新使用次数
//                            TimesCardCustomerRelevance timesCardCustomerRelevance = timesCardCustomerRelevanceService.getById(timesCardUsedRecord.getCardRelevanceCustomerId());
//                            timesCardCustomerRelevance.setUsedTimes(timesCardCustomerRelevance.getUsedTimes() + 1);
//                            if (timesCardCustomerRelevance.getUsedTimes().equals(timesCardCustomerRelevance.getSumTimes())) {
//                                //次数用完
//                                timesCardCustomerRelevance.setStatus(2);
//                            }
//                            timesCardCustomerRelevanceService.updateById(timesCardCustomerRelevance);
                        } else {
                            throw new RRException("次卡冲突");
                        }

                    });
        }

        //卡券之前删除订单服务和卡券关联
//        couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
//                .eq(CouponOrderRelevance::getOrderId, orderId));

        //3、外部券
        if (ListUtil.isNotEmpty(outerCouponCustomerRelevanceServiceList)) {

            //删除之前的外部券抵扣情况记录
//            couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
//                    .eq(CouponOrderRelevance::getOrderId, orderId)
//                    .in(CouponOrderRelevance::getCouponCustomerRelevanceId, outerCouponCustomerRelevanceServiceList.stream().map(CouponCustomerRelevance::getId).collect(Collectors.toList())));
            outerCouponCustomerRelevanceServiceList
                    .stream()
                    .sorted(Comparator.comparing(CouponCustomerRelevance::getDiscountAmount).reversed())
                    .forEach(couponCustomerRelevance -> {

                        //外部券能用的服务id
                        List<Integer> serveIds = couponCustomerRelevanceMapper.queryCouponCustomerServeRelevance(couponCustomerRelevance.getCouponId());

                        //抵扣的服务为 作用范围内支付金额最高的服务
                        OrderServe orderServe = this.queryMaxPayPrice(orderManage, serveIds);

                        if (orderServe != null) {
                            BigDecimal discountAmount = couponCustomerRelevance.getDiscountAmount();
                            if (couponCustomerRelevance.getType() == 5) {
                                discountAmount = orderServe.getPrice().multiply(BigDecimal.ONE.subtract(couponCustomerRelevance.getDiscountPercent()));
                            }
                            //实际折扣的金额
                            BigDecimal actualDiscountAmount = orderServe.getPayPrice().min(discountAmount);

                            //新增外部券抵扣情况记录
                            CouponOrderRelevance couponOrderRelevance = CouponOrderRelevance.builder()
                                    .couponCustomerRelevanceId(couponCustomerRelevance.getId())
                                    .couponId(couponCustomerRelevance.getCouponId())
                                    .couponName(couponCustomerRelevance.getCouponName())
                                    .orderServeId(orderServe.getId())
                                    .serveName(orderServe.getServeName())
                                    .orderId(orderManage.getId())
                                    //支付金额
                                    .payForOrderServe(couponCustomerRelevance.getPayAmount())
                                    //折扣金额
                                    .discountAmount(actualDiscountAmount)
                                    .createTime(new Date())
                                    .confirmTime(new Date())
                                    .message(orderServe.getServeName())
                                    .customerId(orderManage.getOrderUser())
                                    .status(2)
                                    .build();
                            //如果计算业绩
                            if (couponCustomerRelevance.getIsCalcAchievement() == 1) {
                                couponOrderRelevance.setAchievement(couponCustomerRelevance.getPayAmount());
                            }
                            //
                            else {
                                couponOrderRelevance.setAchievement(couponOrderRelevance.getDiscountAmount());
                            }

                            //业绩
                            System.out.println(orderServe.getAchievement());
                            System.out.println(actualDiscountAmount);
                            System.out.println(couponCustomerRelevance.getPayAmount());

                            orderServe.setAchievement(orderServe.getAchievement().subtract(actualDiscountAmount).add(couponCustomerRelevance.getPayAmount()));
                            System.out.println(orderServe.getAchievement());

                            orderServe.addDiscountPrice(actualDiscountAmount);
                            orderManage.addDiscountPrice(actualDiscountAmount);
                            orderServe.setBindOuterCoupon(1);
//                            couponOrderRelevanceService.save(couponOrderRelevance);

                        } else {
                            throw new RRException("%s与其他卡券冲突", couponCustomerRelevance.getCouponName());
                        }

                    });
        }
        //4、内部券
        if (ListUtil.isNotEmpty(innerCouponCustomerRelevanceServiceList)) {

            //删除之前的内部券抵扣情况记录
//            couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
//                    .eq(CouponOrderRelevance::getOrderId, orderId)
//                    .in(CouponOrderRelevance::getCouponCustomerRelevanceId, innerCouponCustomerRelevanceServiceList.stream().map(CouponCustomerRelevance::getId).collect(Collectors.toList())));

            //免单券Id
            List<Integer> discountConfigListCouponId = discountConfigMapper.selectList(new QueryWrapper<>()).stream().map(DiscountConfig::getCouponId).filter(Objects::nonNull).collect(Collectors.toList());

            //内部券计算函数
            Consumer<CouponCustomerRelevance> couponCustomerRelevanceConsumer = couponCustomerRelevance -> {
                //内部券能用的服务id
                List<Integer> serveIds = couponCustomerRelevanceMapper.queryCouponCustomerServeRelevance(couponCustomerRelevance.getCouponId());

                //作用的服务id
                List<OrderServe> canUserOrderServeList = this.queryCanDiscount(orderManage, serveIds, couponCustomerRelevance.getCouponId());

                //打折订单项总支付金额
                BigDecimal total = canUserOrderServeList.stream().map(OrderServe::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);

                if (!total.setScale(2, BigDecimal.ROUND_HALF_UP).equals(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP))) {
                    //卡券的总折扣金额
                    BigDecimal totalCouponDiscount = couponCustomerRelevance.getDiscountAmount();
                    //折扣券
                    if (couponCustomerRelevance.getType().equals(CouponCustomerRelevance.TYPE_DISCOUNT)) {
                        totalCouponDiscount = orderManage.getTotalPaymentAmount().multiply(BigDecimal.ONE.subtract(couponCustomerRelevance.getDiscountPercent()));
                    }
                    //卡券总支付金额
                    BigDecimal totalCouponPay = couponCustomerRelevance.getPayAmount();
                    //计算参数（最后一个订单服务的折扣金额要用总折扣金额减 防止除法计算精度问题）
                    BigDecimal discountCalc = BigDecimal.ZERO;
                    //计算参数（最后一个订单服务的实际支付要用总实际支付金额减 防止除法计算精度问题）
                    BigDecimal payCalc = BigDecimal.ZERO;
                    for (OrderServe orderServe : canUserOrderServeList) {

                        //每个服务的内部券抵扣金额
                        BigDecimal discountAmount = orderServe.getPayPrice().multiply(totalCouponDiscount).divide(total, 2, BigDecimal.ROUND_HALF_UP);
                        //每个服务的卡券实际支付金额
                        BigDecimal payAmount = orderServe.getPayPrice().multiply(totalCouponPay).divide(total, 2, BigDecimal.ROUND_HALF_UP);
                        //最后一个服务使用总额减法而不是除法
                        if (canUserOrderServeList.lastIndexOf(orderServe) == canUserOrderServeList.size() - 1) {
                            discountAmount = totalCouponDiscount.subtract(discountCalc);
                            payAmount = totalCouponPay.subtract(payCalc);
                        }

                        BigDecimal actualDiscountAmount = discountAmount.min(orderServe.getPayPrice());
                        //卡券在订单服务上的抵扣情况
                        CouponOrderRelevance couponOrderRelevance = CouponOrderRelevance.builder()
                                .discountAmount(actualDiscountAmount)
                                //卡券在这个服务上的实际支付金额
                                .payForOrderServe(payAmount)
                                .createTime(new Date())
                                .orderServeId(orderServe.getId())
                                .orderId(orderManage.getId())
                                .couponId(couponCustomerRelevance.getCouponId())
                                .couponCustomerRelevanceId(couponCustomerRelevance.getId())
                                .confirmTime(new Date())
                                .message(orderServe.getServeName())
                                .customerId(orderManage.getOrderUser())
                                .status(2)
                                .build();

                        //如果计算业绩
                        if (couponCustomerRelevance.getIsCalcAchievement() == 1) {
                            couponOrderRelevance.setAchievement(couponCustomerRelevance.getPayAmount());
                        } else {
                            couponOrderRelevance.setAchievement(couponOrderRelevance.getDiscountAmount());
                        }
                        //保存卡券在订单服务上的使用情况
//                        couponOrderRelevanceService.save(couponOrderRelevance);
                        System.out.println(orderServe.getAchievement());

                        //如果不是免单券 业绩就要扣除实际折扣金额
                        if (!discountConfigListCouponId.contains(couponCustomerRelevance.getCouponId())) {
                            System.out.println(orderServe.getAchievement());
                            System.out.println(actualDiscountAmount);

                            orderServe.setAchievement(orderServe.getAchievement().subtract(actualDiscountAmount));
                            System.out.println(orderServe.getAchievement());

                        }

                        orderServe.addDiscountPrice(actualDiscountAmount);
                        orderManage.addDiscountPrice(actualDiscountAmount);

                        orderServe.setBindInnerCoupon(1);
                        discountCalc = discountCalc.add(discountAmount);
                        payCalc = payCalc.add(payAmount);
                    }
                }
                //内部券抵扣不了
                else {
                    throw new RRException("%s与其他卡券冲突", couponCustomerRelevance.getCouponName());
                }
            };

            //5、免单券
            List<CouponCustomerRelevance> freeInnerCouponCustomerRelevanceServiceList = innerCouponCustomerRelevanceServiceList
                    .stream()
                    .filter(couponCustomerRelevance -> discountConfigListCouponId.contains(couponCustomerRelevance.getCouponId()))
                    .collect(Collectors.toList());
            freeInnerCouponCustomerRelevanceServiceList.forEach(couponCustomerRelevanceConsumer);

            //6、普通内部券
            List<CouponCustomerRelevance> normalInnerCouponCustomerRelevanceServiceList = innerCouponCustomerRelevanceServiceList
                    .stream()
                    //不是免单券
                    .filter(couponCustomerRelevance -> !discountConfigListCouponId.contains(couponCustomerRelevance.getCouponId()))
                    //不是折扣券
                    .filter(couponCustomerRelevance -> !couponCustomerRelevance.getType().equals(CouponCustomerRelevance.TYPE_DISCOUNT))
                    .collect(Collectors.toList());
            if (normalInnerCouponCustomerRelevanceServiceList.size() > 1) {
                throw new RRException("普通内部券只能用一张");
            }
            normalInnerCouponCustomerRelevanceServiceList.forEach(couponCustomerRelevanceConsumer);


            //6、折扣内部券
            List<CouponCustomerRelevance> discountInnerCouponCustomerRelevanceServiceList = innerCouponCustomerRelevanceServiceList
                    .stream()
                    //不是免单券
                    .filter(couponCustomerRelevance -> !discountConfigListCouponId.contains(couponCustomerRelevance.getCouponId()))
                    //是折扣券
                    .filter(couponCustomerRelevance -> couponCustomerRelevance.getType().equals(CouponCustomerRelevance.TYPE_DISCOUNT))
                    .collect(Collectors.toList());
            discountInnerCouponCustomerRelevanceServiceList.forEach(couponCustomerRelevanceConsumer);

            if (normalInnerCouponCustomerRelevanceServiceList.size() + discountInnerCouponCustomerRelevanceServiceList.size() > 1) {
                throw new RRException("普通内部券只能用一张");
            }
            if (freeInnerCouponCustomerRelevanceServiceList.size() > 1) {
                throw new RRException("免单券券只能用一张");
            }
        }
//        orderManageMapper.updateById(orderManage);
//        orderServeService.updateBatchById(orderServeList);
        orderServeList.forEach(orderServe -> {
            OrderServe updateOrderServe = orderServeMapper.selectById(orderServe.getId());
            updateOrderServe.setAchievement(orderServe.getAchievement());
            orderServeMapper.updateById(updateOrderServe);
        });

    }

    @Override
    public void orderAmountReCalc(Integer orderId) {

        //订单使用的内部券
        List<CouponCustomerRelevance> innerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
                .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, orderId)
                        .eq(CouponCustomerRelevance::getState, CouponCustomerRelevance.STATE_USED)
                        .eq(CouponCustomerRelevance::getSourceType, 0));

        //订单使用的外部券
        List<CouponCustomerRelevance> outerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
                .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, orderId)
                        .eq(CouponCustomerRelevance::getState, CouponCustomerRelevance.STATE_USED)
                        .eq(CouponCustomerRelevance::getSourceType, 1));

        //订单使用的次卡
        List<TimesCardUsedRecord> timesCardUsedRecordList = timesCardUsedRecordService
                .list(new LambdaQueryWrapper<TimesCardUsedRecord>()
                        .eq(TimesCardUsedRecord::getOrderId, orderId)
                        .eq(TimesCardUsedRecord::getStatus, TimesCardUsedRecord.STATUS_USED));

        //查询订单聚合
        OrderManage orderManage = orderManageMapper.selectById(orderId);
        List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, orderId));
        orderManage.setListOrderServer(orderServeList);

        //order serve 卡券绑定状态reset
        orderServeList.forEach(orderServe -> {
            orderServe.setBindInnerCoupon(2);
            orderServe.setBindTimesCard(2);
            orderServe.setBindOuterCoupon(2);
        });

        //1、改价结算
        //总支付金额等于 总价格+总改价
        orderManage.setTotalPaymentAmount(orderManage.getTotalPrice().add(orderManage.getChangePrice()));
        //总折扣金额
        orderManage.setDiscountPrice(BigDecimal.ZERO);

        orderManage.getListOrderServer().forEach(orderServe -> {
            //服务实际支付金额=服务价格+服务改价
            orderServe.setPayPrice(orderServe.getPrice().add(orderServe.getServeChangePrice()));
            //服务折金额=0
            orderServe.setDiscountPrice(BigDecimal.ZERO);
            //如果是贵族会员免费手部基础护理 或者 特级会员免费修手 业绩为10元 其他的是实际支付金额
            if (orderServe.getServeName().equals("贵族会员免费手部基础护理")
                    || orderServe.getServeName().equals("特级会员免费修手")) {
                orderServe.setAchievement(new BigDecimal(10).add(orderServe.getServeChangePrice()));
            } else {
                orderServe.setAchievement(orderServe.getPrice().add(orderServe.getServeChangePrice()));
            }
        });

        //2、次卡
        if (ListUtil.isNotEmpty(timesCardUsedRecordList)) {
            //次卡使用记录
            timesCardUsedRecordList.forEach(timesCardUsedRecord -> timesCardUsedRecord.setStatus(TimesCardUsedRecord.STATUS_CHOSE));

            timesCardUsedRecordList.stream()
                    .sorted(Comparator.comparing(TimesCardUsedRecord::getDiscountAmount))
                    .forEach(timesCardUsedRecord -> {

                        timesCardOrderServeDetailMapper.delete(new LambdaQueryWrapper<TimesCardOrderServeDetail>().eq(TimesCardOrderServeDetail::getOrderId, orderId));

                        //次卡能用的服务id
                        List<Integer> serveIds = timesCardCustomerRelevanceMapper.queryTimesCardServeIds(timesCardUsedRecord.getCardTypeId());
                        //抵扣的服务为 作用范围内支付金额最高的服务
                        OrderServe orderServe = this.queryMaxPayPrice(orderManage, serveIds);
                        if (orderServe != null) {

                            BigDecimal actualDiscountAmount = orderServe.getPayPrice().min(timesCardUsedRecord.getDiscountAmount());
                            //更新次卡记录 已使用
                            timesCardUsedRecord.setStatus(TimesCardUsedRecord.STATUS_USED);
                            //次卡对应订单服务的美甲师
                            timesCardUsedRecord.setTechnicianName(orderServe.getTechnicianName());
                            //次卡店铺名称
                            timesCardUsedRecord.setDepartmentName(orderManage.getDepartmentName());
                            //次卡店铺id
                            timesCardUsedRecord.setDepartmentId(orderManage.getDepartmentId());
                            //次卡折扣的
                            timesCardUsedRecord.setServeName(orderServe.getServeName());
                            //次卡作用的服务id
                            timesCardUsedRecord.setOrderServeId(orderServe.getServeId());
                            timesCardUsedRecord.setOrderId(orderId);
                            timesCardUsedRecord.setActualDiscountAmount(actualDiscountAmount);
                            timesCardUsedRecordService.updateById(timesCardUsedRecord);

                            //在主服务上折扣的钱
                            TimesCardOrderServeDetail timesCardOrderServeDetail = new TimesCardOrderServeDetail();
                            timesCardOrderServeDetail.setDiscountAmount(actualDiscountAmount);
                            timesCardOrderServeDetail.setOrderServeId(orderServe.getId());
                            timesCardOrderServeDetail.setOrderId(orderId);
                            timesCardOrderServeDetail.setTimesCardUserRecordId(timesCardUsedRecord.getOrderServeId());
                            //业绩
                            timesCardOrderServeDetail.setAchievement(timesCardUsedRecord.getPayAmount());
                            timesCardOrderServeDetailMapper.insert(timesCardOrderServeDetail);

                            //订单折扣金额更新
                            orderServe.setBindTimesCard(1);
                            orderServe.addDiscountPrice(actualDiscountAmount);

                            //业绩
                            orderServe.setAchievement(orderServe.getAchievement().subtract(actualDiscountAmount).add(timesCardUsedRecord.getPayAmount()));
                            orderManage.addDiscountPrice(actualDiscountAmount);

//                            //更新使用次数
//                            TimesCardCustomerRelevance timesCardCustomerRelevance = timesCardCustomerRelevanceService.getById(timesCardUsedRecord.getCardRelevanceCustomerId());
//                            timesCardCustomerRelevance.setUsedTimes(timesCardCustomerRelevance.getUsedTimes() + 1);
//                            if (timesCardCustomerRelevance.getUsedTimes().equals(timesCardCustomerRelevance.getSumTimes())) {
//                                //次数用完
//                                timesCardCustomerRelevance.setStatus(2);
//                            }
//                            timesCardCustomerRelevanceService.updateById(timesCardCustomerRelevance);
                        } else {
                            throw new RRException("次卡冲突");
                        }

                    });
        }

        //卡券之前删除订单服务和卡券关联
        couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
                .eq(CouponOrderRelevance::getOrderId, orderId));

        //3、外部券
        if (ListUtil.isNotEmpty(outerCouponCustomerRelevanceServiceList)) {

            //删除之前的外部券抵扣情况记录
            couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
                    .eq(CouponOrderRelevance::getOrderId, orderId)
                    .in(CouponOrderRelevance::getCouponCustomerRelevanceId, outerCouponCustomerRelevanceServiceList.stream().map(CouponCustomerRelevance::getId).collect(Collectors.toList())));


            outerCouponCustomerRelevanceServiceList
                    .stream()
                    .sorted(Comparator.comparing(CouponCustomerRelevance::getDiscountAmount).reversed())
                    .forEach(couponCustomerRelevance -> {


                        //外部券能用的服务id
                        List<Integer> serveIds = couponCustomerRelevanceMapper.queryCouponCustomerServeRelevance(couponCustomerRelevance.getCouponId());

                        //抵扣的服务为 作用范围内支付金额最高的服务
                        OrderServe orderServe = this.queryMaxPayPrice(orderManage, serveIds);

                        if (orderServe != null) {
                            BigDecimal discountAmount = couponCustomerRelevance.getDiscountAmount();
                            if (couponCustomerRelevance.getType() == 5) {
                                discountAmount = orderServe.getPrice().multiply(BigDecimal.ONE.subtract(couponCustomerRelevance.getDiscountPercent()));
                            }
                            BigDecimal actualDiscountAmount = orderServe.getPayPrice().min(discountAmount);

                            //新增外部券抵扣情况记录
                            CouponOrderRelevance couponOrderRelevance = CouponOrderRelevance.builder()
                                    .couponCustomerRelevanceId(couponCustomerRelevance.getId())
                                    .couponId(couponCustomerRelevance.getCouponId())
                                    .couponName(couponCustomerRelevance.getCouponName())
                                    .orderServeId(orderServe.getId())
                                    .serveName(orderServe.getServeName())
                                    .orderId(orderManage.getId())
                                    //支付金额
                                    .payForOrderServe(couponCustomerRelevance.getPayAmount())
                                    //折扣金额
                                    .discountAmount(actualDiscountAmount)
                                    .createTime(new Date())
                                    .confirmTime(new Date())
                                    .message(orderServe.getServeName())
                                    .customerId(orderManage.getOrderUser())
                                    .status(2)
                                    .build();
                            //如果计算业绩
                            if (couponCustomerRelevance.getIsCalcAchievement() == 1) {
                                couponOrderRelevance.setAchievement(couponCustomerRelevance.getPayAmount());
                            } else {
                                couponOrderRelevance.setAchievement(couponOrderRelevance.getDiscountAmount());
                            }

                            //业绩
                            orderServe.setAchievement(orderServe.getAchievement().subtract(actualDiscountAmount).add(couponCustomerRelevance.getPayAmount()));

                            orderServe.addDiscountPrice(actualDiscountAmount);
                            orderManage.addDiscountPrice(actualDiscountAmount);
                            orderServe.setBindOuterCoupon(1);
                            couponOrderRelevanceService.save(couponOrderRelevance);

                        } else {
                            throw new RRException("%s与其他卡券冲突", couponCustomerRelevance.getCouponName());
                        }

                    });
        }
        //4、内部券
        if (ListUtil.isNotEmpty(innerCouponCustomerRelevanceServiceList)) {

            //删除之前的内部券抵扣情况记录
            couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
                    .eq(CouponOrderRelevance::getOrderId, orderId)
                    .in(CouponOrderRelevance::getCouponCustomerRelevanceId, innerCouponCustomerRelevanceServiceList.stream().map(CouponCustomerRelevance::getId).collect(Collectors.toList())));

            //免单券Id
            List<Integer> discountConfigListCouponId = discountConfigMapper.selectList(new QueryWrapper<>()).stream().map(DiscountConfig::getCouponId).filter(Objects::nonNull).collect(Collectors.toList());

            //内部券计算函数
            Consumer<CouponCustomerRelevance> couponCustomerRelevanceConsumer = couponCustomerRelevance -> {
                //内部券能用的服务id
                List<Integer> serveIds = couponCustomerRelevanceMapper.queryCouponCustomerServeRelevance(couponCustomerRelevance.getCouponId());

                //作用的服务id
                List<OrderServe> canUserOrderServeList = this.queryCanDiscount(orderManage, serveIds, couponCustomerRelevance.getCouponId());

                //打折订单项总支付金额
                BigDecimal total = canUserOrderServeList.stream().map(OrderServe::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);

                if (!total.setScale(2, BigDecimal.ROUND_HALF_UP).equals(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP))) {
                    //卡券的总折扣金额
                    BigDecimal totalCouponDiscount = couponCustomerRelevance.getDiscountAmount();
                    //折扣券
                    if (couponCustomerRelevance.getType().equals(CouponCustomerRelevance.TYPE_DISCOUNT)) {
                        totalCouponDiscount = orderManage.getTotalPaymentAmount().multiply(BigDecimal.ONE.subtract(couponCustomerRelevance.getDiscountPercent()));
                    }
                    //卡券总支付金额
                    BigDecimal totalCouponPay = couponCustomerRelevance.getPayAmount();
                    //计算参数（最后一个订单服务的折扣金额要用总折扣金额减 防止除法计算精度问题）
                    BigDecimal discountCalc = BigDecimal.ZERO;
                    //计算参数（最后一个订单服务的实际支付要用总实际支付金额减 防止除法计算精度问题）
                    BigDecimal payCalc = BigDecimal.ZERO;
                    for (OrderServe orderServe : canUserOrderServeList) {

                        //每个服务的内部券抵扣金额
                        BigDecimal discountAmount = orderServe.getPayPrice().multiply(totalCouponDiscount).divide(total, 2, BigDecimal.ROUND_HALF_UP);
                        //每个服务的卡券实际支付金额
                        BigDecimal payAmount = orderServe.getPayPrice().multiply(totalCouponPay).divide(total, 2, BigDecimal.ROUND_HALF_UP);
                        //最后一个服务使用总额减法而不是除法
                        if (canUserOrderServeList.lastIndexOf(orderServe) == canUserOrderServeList.size() - 1) {
                            discountAmount = totalCouponDiscount.subtract(discountCalc);
                            payAmount = totalCouponPay.subtract(payCalc);
                        }

                        BigDecimal actualDiscountAmount = discountAmount.min(orderServe.getPayPrice());
                        //卡券在订单服务上的抵扣情况
                        CouponOrderRelevance couponOrderRelevance = CouponOrderRelevance.builder()
                                .discountAmount(actualDiscountAmount)
                                //卡券在这个服务上的实际支付金额
                                .payForOrderServe(payAmount)
                                .createTime(new Date())
                                .orderServeId(orderServe.getId())
                                .orderId(orderManage.getId())
                                .couponId(couponCustomerRelevance.getCouponId())
                                .couponCustomerRelevanceId(couponCustomerRelevance.getId())
                                .confirmTime(new Date())
                                .message(orderServe.getServeName())
                                .customerId(orderManage.getOrderUser())
                                .status(2)
                                .build();

                        //如果计算业绩
                        if (couponCustomerRelevance.getIsCalcAchievement() == 1) {
                            couponOrderRelevance.setAchievement(couponCustomerRelevance.getPayAmount());
                        } else {
                            couponOrderRelevance.setAchievement(couponOrderRelevance.getDiscountAmount());
                        }
                        //保存卡券在订单服务上的使用情况
                        couponOrderRelevanceService.save(couponOrderRelevance);

                        //如果不是免单券 业绩就要扣除实际折扣金额
                        if (!discountConfigListCouponId.contains(couponCustomerRelevance.getCouponId())) {
                            orderServe.setAchievement(orderServe.getAchievement().subtract(actualDiscountAmount));
                        }

                        orderServe.addDiscountPrice(actualDiscountAmount);
                        orderManage.addDiscountPrice(actualDiscountAmount);

                        orderServe.setBindInnerCoupon(1);
                        discountCalc = discountCalc.add(discountAmount);
                        payCalc = payCalc.add(payAmount);
                    }
                }
                //内部券抵扣不了
                else {
                    throw new RRException("%s与其他卡券冲突", couponCustomerRelevance.getCouponName());
                }
            };

            //5、免单券
            List<CouponCustomerRelevance> freeInnerCouponCustomerRelevanceServiceList = innerCouponCustomerRelevanceServiceList
                    .stream()
                    .filter(couponCustomerRelevance -> discountConfigListCouponId.contains(couponCustomerRelevance.getCouponId()))
                    .collect(Collectors.toList());
            freeInnerCouponCustomerRelevanceServiceList.forEach(couponCustomerRelevanceConsumer);

            //6、普通内部券
            List<CouponCustomerRelevance> normalInnerCouponCustomerRelevanceServiceList = innerCouponCustomerRelevanceServiceList
                    .stream()
                    //不是免单券
                    .filter(couponCustomerRelevance -> !discountConfigListCouponId.contains(couponCustomerRelevance.getCouponId()))
                    //不是折扣券
                    .filter(couponCustomerRelevance -> !couponCustomerRelevance.getType().equals(CouponCustomerRelevance.TYPE_DISCOUNT))
                    .collect(Collectors.toList());
            if (normalInnerCouponCustomerRelevanceServiceList.size() > 1) {
                throw new RRException("普通内部券只能用一张");
            }
            normalInnerCouponCustomerRelevanceServiceList.forEach(couponCustomerRelevanceConsumer);


            //6、折扣内部券
            List<CouponCustomerRelevance> discountInnerCouponCustomerRelevanceServiceList = innerCouponCustomerRelevanceServiceList
                    .stream()
                    //不是免单券
                    .filter(couponCustomerRelevance -> !discountConfigListCouponId.contains(couponCustomerRelevance.getCouponId()))
                    //是折扣券
                    .filter(couponCustomerRelevance -> couponCustomerRelevance.getType().equals(CouponCustomerRelevance.TYPE_DISCOUNT))
                    .collect(Collectors.toList());
            discountInnerCouponCustomerRelevanceServiceList.forEach(couponCustomerRelevanceConsumer);

            if (normalInnerCouponCustomerRelevanceServiceList.size() + discountInnerCouponCustomerRelevanceServiceList.size() > 1) {
                throw new RRException("普通内部券只能用一张");
            }
            if (freeInnerCouponCustomerRelevanceServiceList.size() > 1) {
                throw new RRException("免单券券只能用一张");
            }
        }
        orderManageMapper.updateById(orderManage);
        orderServeService.updateBatchById(orderServeList);
    }


    /**
     * 更新订单 使用次卡 使用外部券 使用内部券之后需要调用这个方法
     * 结算订单
     *
     * @param orderId
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void calcOrderAmount(Integer orderId) {

        //订单使用的内部券
        List<CouponCustomerRelevance> innerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
                .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, orderId)
                        .eq(CouponCustomerRelevance::getState, CouponCustomerRelevance.STATE_CHOSE)
                        .eq(CouponCustomerRelevance::getSourceType, 0));

        //订单使用的外部券
        List<CouponCustomerRelevance> outerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
                .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, orderId)
                        .eq(CouponCustomerRelevance::getState, CouponCustomerRelevance.STATE_CHOSE)
                        .eq(CouponCustomerRelevance::getSourceType, 1));

        //订单使用的次卡
        List<TimesCardUsedRecord> timesCardUsedRecordList = timesCardUsedRecordService
                .list(new LambdaQueryWrapper<TimesCardUsedRecord>()
                        .eq(TimesCardUsedRecord::getOrderId, orderId)
                        .eq(TimesCardUsedRecord::getStatus, TimesCardUsedRecord.STATUS_CHOSE));

        //查询订单聚合
        OrderManage orderManage = orderManageMapper.selectById(orderId);
        List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, orderId));
        orderManage.setListOrderServer(orderServeList);

        //order serve 卡券绑定状态reset
        orderServeList.forEach(orderServe -> {
            orderServe.setBindInnerCoupon(2);
            orderServe.setBindTimesCard(2);
            orderServe.setBindOuterCoupon(2);
        });

        //1、改价结算
        //总支付金额等于 总价格+总改价
        orderManage.setTotalPaymentAmount(orderManage.getTotalPrice().add(orderManage.getChangePrice()));
        //总折扣金额
        orderManage.setDiscountPrice(BigDecimal.ZERO);

        orderManage.getListOrderServer().forEach(orderServe -> {
            //服务实际支付金额=服务价格+服务改价
            orderServe.setPayPrice(orderServe.getPrice().add(orderServe.getServeChangePrice()));
            //服务折金额=0
            orderServe.setDiscountPrice(BigDecimal.ZERO);
            //如果是贵族会员免费手部基础护理 或者 特级会员免费修手 业绩为10元 其他的是实际支付金额
            if (orderServe.getServeName().equals("贵族会员免费手部基础护理")
                    || orderServe.getServeName().equals("特级会员免费修手")) {
                orderServe.setAchievement(new BigDecimal(10).add(orderServe.getServeChangePrice()));
            } else {
                orderServe.setAchievement(orderServe.getPrice().add(orderServe.getServeChangePrice()));
            }
        });


        //卡券之前删除订单服务和卡券关联
        couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
                .eq(CouponOrderRelevance::getOrderId, orderId));

        //3、外部券
        if (ListUtil.isNotEmpty(outerCouponCustomerRelevanceServiceList)) {

            //删除之前的外部券抵扣情况记录
            couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
                    .eq(CouponOrderRelevance::getOrderId, orderId)
                    .in(CouponOrderRelevance::getCouponCustomerRelevanceId, outerCouponCustomerRelevanceServiceList.stream().map(CouponCustomerRelevance::getId).collect(Collectors.toList())));


            outerCouponCustomerRelevanceServiceList
                    .stream()
                    .sorted(Comparator.comparing(CouponCustomerRelevance::getDiscountAmount).reversed())
                    .forEach(couponCustomerRelevance -> {


                        //外部券能用的服务id
                        List<Integer> serveIds = couponCustomerRelevanceMapper.queryCouponCustomerServeRelevance(couponCustomerRelevance.getCouponId());

                        //抵扣的服务为 作用范围内支付金额最高的服务
                        OrderServe orderServe = this.queryMaxPayPrice(orderManage, serveIds);

                        if (orderServe != null) {
                            BigDecimal discountAmount = couponCustomerRelevance.getDiscountAmount();
                            if (couponCustomerRelevance.getType() == 5) {
                                discountAmount = orderServe.getPrice().multiply(BigDecimal.ONE.subtract(couponCustomerRelevance.getDiscountPercent()));
                            }
                            BigDecimal actualDiscountAmount = orderServe.getPayPrice().min(discountAmount);

                            //新增外部券抵扣情况记录
                            CouponOrderRelevance couponOrderRelevance = CouponOrderRelevance.builder()
                                    .couponCustomerRelevanceId(couponCustomerRelevance.getId())
                                    .couponId(couponCustomerRelevance.getCouponId())
                                    .couponName(couponCustomerRelevance.getCouponName())
                                    .orderServeId(orderServe.getId())
                                    .serveName(orderServe.getServeName())
                                    .orderId(orderManage.getId())
                                    //支付金额
                                    .payForOrderServe(couponCustomerRelevance.getPayAmount())
                                    //折扣金额
                                    .discountAmount(actualDiscountAmount)
                                    .createTime(new Date())
                                    .confirmTime(new Date())
                                    .message(orderServe.getServeName())
                                    .customerId(orderManage.getOrderUser())
                                    .status(2)
                                    .build();
                            //如果计算业绩
                            if (couponCustomerRelevance.getIsCalcAchievement() == 1) {
                                couponOrderRelevance.setAchievement(couponCustomerRelevance.getPayAmount());
                            } else {
                                couponOrderRelevance.setAchievement(couponOrderRelevance.getDiscountAmount());
                            }

                            //业绩
                            orderServe.setAchievement(orderServe.getAchievement().subtract(actualDiscountAmount).add(couponCustomerRelevance.getPayAmount()));

                            orderServe.addDiscountPrice(actualDiscountAmount);
                            orderManage.addDiscountPrice(actualDiscountAmount);
                            orderServe.setBindOuterCoupon(1);
                            couponOrderRelevanceService.save(couponOrderRelevance);

                        } else {
                            throw new RRException("%s与其他卡券冲突", couponCustomerRelevance.getCouponName());
                        }

                    });
        }
        //4、内部券
        if (ListUtil.isNotEmpty(innerCouponCustomerRelevanceServiceList)) {

            //删除之前的内部券抵扣情况记录
            couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
                    .eq(CouponOrderRelevance::getOrderId, orderId)
                    .in(CouponOrderRelevance::getCouponCustomerRelevanceId, innerCouponCustomerRelevanceServiceList.stream().map(CouponCustomerRelevance::getId).collect(Collectors.toList())));

            //免单券Id
            List<Integer> discountConfigListCouponId = discountConfigMapper.selectList(new QueryWrapper<>()).stream().map(DiscountConfig::getCouponId).filter(Objects::nonNull).collect(Collectors.toList());

            //内部券计算函数
            Consumer<CouponCustomerRelevance> couponCustomerRelevanceConsumer = couponCustomerRelevance -> {
                //内部券能用的服务id
                List<Integer> serveIds = couponCustomerRelevanceMapper.queryCouponCustomerServeRelevance(couponCustomerRelevance.getCouponId());

                //作用的服务id
                List<OrderServe> canUserOrderServeList = this.queryCanDiscount(orderManage, serveIds, couponCustomerRelevance.getCouponId());

                //打折订单项总支付金额
                BigDecimal total = canUserOrderServeList.stream().map(OrderServe::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);

                if (!total.setScale(2, BigDecimal.ROUND_HALF_UP).equals(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP))) {
                    //卡券的总折扣金额
                    BigDecimal totalCouponDiscount = couponCustomerRelevance.getDiscountAmount();
                    //折扣券
                    if (couponCustomerRelevance.getType().equals(CouponCustomerRelevance.TYPE_DISCOUNT)) {
                        totalCouponDiscount = orderManage.getTotalPaymentAmount().multiply(BigDecimal.ONE.subtract(couponCustomerRelevance.getDiscountPercent()));
                    }
                    //卡券总支付金额
                    BigDecimal totalCouponPay = couponCustomerRelevance.getPayAmount();
                    //计算参数（最后一个订单服务的折扣金额要用总折扣金额减 防止除法计算精度问题）
                    BigDecimal discountCalc = BigDecimal.ZERO;
                    //计算参数（最后一个订单服务的实际支付要用总实际支付金额减 防止除法计算精度问题）
                    BigDecimal payCalc = BigDecimal.ZERO;
                    for (OrderServe orderServe : canUserOrderServeList) {

                        //每个服务的内部券抵扣金额
                        BigDecimal discountAmount = orderServe.getPayPrice().multiply(totalCouponDiscount).divide(total, 2, BigDecimal.ROUND_HALF_UP);
                        //每个服务的卡券实际支付金额
                        BigDecimal payAmount = orderServe.getPayPrice().multiply(totalCouponPay).divide(total, 2, BigDecimal.ROUND_HALF_UP);
                        //最后一个服务使用总额减法而不是除法
                        if (canUserOrderServeList.lastIndexOf(orderServe) == canUserOrderServeList.size() - 1) {
                            discountAmount = totalCouponDiscount.subtract(discountCalc);
                            payAmount = totalCouponPay.subtract(payCalc);
                        }

                        BigDecimal actualDiscountAmount = discountAmount.min(orderServe.getPayPrice());
                        //卡券在订单服务上的抵扣情况
                        CouponOrderRelevance couponOrderRelevance = CouponOrderRelevance.builder()
                                .discountAmount(actualDiscountAmount)
                                //卡券在这个服务上的实际支付金额
                                .payForOrderServe(payAmount)
                                .createTime(new Date())
                                .orderServeId(orderServe.getId())
                                .orderId(orderManage.getId())
                                .couponId(couponCustomerRelevance.getCouponId())
                                .couponCustomerRelevanceId(couponCustomerRelevance.getId())
                                .confirmTime(new Date())
                                .message(orderServe.getServeName())
                                .customerId(orderManage.getOrderUser())
                                .status(2)
                                .build();

                        //如果计算业绩
                        if (couponCustomerRelevance.getIsCalcAchievement() == 1) {
                            couponOrderRelevance.setAchievement(couponCustomerRelevance.getPayAmount());
                        } else {
                            couponOrderRelevance.setAchievement(couponOrderRelevance.getDiscountAmount());
                        }
                        //保存卡券在订单服务上的使用情况
                        couponOrderRelevanceService.save(couponOrderRelevance);

                        //如果不是免单券 业绩就要扣除实际折扣金额
                        if (!discountConfigListCouponId.contains(couponCustomerRelevance.getCouponId())) {
                            orderServe.setAchievement(orderServe.getAchievement().subtract(actualDiscountAmount));
                        }

                        orderServe.addDiscountPrice(actualDiscountAmount);
                        orderManage.addDiscountPrice(actualDiscountAmount);

                        orderServe.setBindInnerCoupon(1);
                        discountCalc = discountCalc.add(discountAmount);
                        payCalc = payCalc.add(payAmount);
                    }
                }
                //内部券抵扣不了
                else {
                    throw new RRException("%s与其他卡券冲突", couponCustomerRelevance.getCouponName());
                }
            };

            //5、免单券
            List<CouponCustomerRelevance> freeInnerCouponCustomerRelevanceServiceList = innerCouponCustomerRelevanceServiceList
                    .stream()
                    .filter(couponCustomerRelevance -> discountConfigListCouponId.contains(couponCustomerRelevance.getCouponId()))
                    .collect(Collectors.toList());
            freeInnerCouponCustomerRelevanceServiceList.forEach(couponCustomerRelevanceConsumer);


            //2、次卡
            if (ListUtil.isNotEmpty(timesCardUsedRecordList)) {
                //次卡使用记录
                timesCardUsedRecordList.forEach(timesCardUsedRecord -> timesCardUsedRecord.setStatus(TimesCardUsedRecord.STATUS_CHOSE));

                timesCardUsedRecordList.stream()
                        .sorted(Comparator.comparing(TimesCardUsedRecord::getDiscountAmount))
                        .forEach(timesCardUsedRecord -> {

                            timesCardOrderServeDetailMapper.delete(new LambdaQueryWrapper<TimesCardOrderServeDetail>().eq(TimesCardOrderServeDetail::getOrderId, orderId));

                            //次卡能用的服务id
                            List<Integer> serveIds = timesCardCustomerRelevanceMapper.queryTimesCardServeIds(timesCardUsedRecord.getCardTypeId());
                            //抵扣的服务为 作用范围内支付金额最高的服务
                            OrderServe orderServe = this.queryMaxPayPrice(orderManage, serveIds);
                            if (orderServe != null) {

                                BigDecimal actualDiscountAmount = orderServe.getPayPrice().min(timesCardUsedRecord.getDiscountAmount());
                                //更新次卡记录 已使用
                                timesCardUsedRecord.setStatus(TimesCardUsedRecord.STATUS_USED);
                                //次卡对应订单服务的美甲师
                                timesCardUsedRecord.setTechnicianName(orderServe.getTechnicianName());
                                //次卡店铺名称
                                timesCardUsedRecord.setDepartmentName(orderManage.getDepartmentName());
                                //次卡店铺id
                                timesCardUsedRecord.setDepartmentId(orderManage.getDepartmentId());
                                //次卡折扣的
                                timesCardUsedRecord.setServeName(orderServe.getServeName());
                                //次卡作用的服务id
                                timesCardUsedRecord.setOrderServeId(orderServe.getServeId());
                                timesCardUsedRecord.setOrderId(orderId);
                                timesCardUsedRecord.setActualDiscountAmount(actualDiscountAmount);
                                timesCardUsedRecordService.updateById(timesCardUsedRecord);

                                //在主服务上折扣的钱
                                TimesCardOrderServeDetail timesCardOrderServeDetail = new TimesCardOrderServeDetail();
                                timesCardOrderServeDetail.setDiscountAmount(actualDiscountAmount);
                                timesCardOrderServeDetail.setOrderServeId(orderServe.getId());
                                timesCardOrderServeDetail.setOrderId(orderId);
                                timesCardOrderServeDetail.setTimesCardUserRecordId(timesCardUsedRecord.getOrderServeId());
                                //业绩
                                timesCardOrderServeDetail.setAchievement(timesCardUsedRecord.getPayAmount());
                                timesCardOrderServeDetailMapper.insert(timesCardOrderServeDetail);

                                //订单折扣金额更新
                                orderServe.setBindTimesCard(1);
                                orderServe.addDiscountPrice(actualDiscountAmount);

                                //业绩
                                orderServe.setAchievement(orderServe.getAchievement().subtract(actualDiscountAmount).add(timesCardUsedRecord.getPayAmount()));
                                orderManage.addDiscountPrice(actualDiscountAmount);

//                            //更新使用次数
//                            TimesCardCustomerRelevance timesCardCustomerRelevance = timesCardCustomerRelevanceService.getById(timesCardUsedRecord.getCardRelevanceCustomerId());
//                            timesCardCustomerRelevance.setUsedTimes(timesCardCustomerRelevance.getUsedTimes() + 1);
//                            if (timesCardCustomerRelevance.getUsedTimes().equals(timesCardCustomerRelevance.getSumTimes())) {
//                                //次数用完
//                                timesCardCustomerRelevance.setStatus(2);
//                            }
//                            timesCardCustomerRelevanceService.updateById(timesCardCustomerRelevance);
                            } else {
                                throw new RRException("次卡冲突");
                            }

                        });
            }

            //6、普通内部券
            List<CouponCustomerRelevance> normalInnerCouponCustomerRelevanceServiceList = innerCouponCustomerRelevanceServiceList
                    .stream()
                    //不是免单券
                    .filter(couponCustomerRelevance -> !discountConfigListCouponId.contains(couponCustomerRelevance.getCouponId()))
                    //不是折扣券
                    .filter(couponCustomerRelevance -> !couponCustomerRelevance.getType().equals(CouponCustomerRelevance.TYPE_DISCOUNT))
                    .collect(Collectors.toList());
            if (normalInnerCouponCustomerRelevanceServiceList.size() > 1) {
                throw new RRException("普通内部券只能用一张");
            }
            normalInnerCouponCustomerRelevanceServiceList.forEach(couponCustomerRelevanceConsumer);


            //6、折扣内部券
            List<CouponCustomerRelevance> discountInnerCouponCustomerRelevanceServiceList = innerCouponCustomerRelevanceServiceList
                    .stream()
                    //不是免单券
                    .filter(couponCustomerRelevance -> !discountConfigListCouponId.contains(couponCustomerRelevance.getCouponId()))
                    //是折扣券
                    .filter(couponCustomerRelevance -> couponCustomerRelevance.getType().equals(CouponCustomerRelevance.TYPE_DISCOUNT))
                    .collect(Collectors.toList());
            discountInnerCouponCustomerRelevanceServiceList.forEach(couponCustomerRelevanceConsumer);

            if (normalInnerCouponCustomerRelevanceServiceList.size() + discountInnerCouponCustomerRelevanceServiceList.size() > 1) {
                throw new RRException("普通内部券只能用一张");
            }
            if (freeInnerCouponCustomerRelevanceServiceList.size() > 1) {
                throw new RRException("免单券券只能用一张");
            }
        }
        orderManageMapper.updateById(orderManage);
        orderServeService.updateBatchById(orderServeList);
    }

    @Transactional(rollbackFor = Exception.class)
    @Async
    @Override
    public void asyncAutoSetCoupon(Integer couponCustomerRelevanceId, Integer orderId) {
        this.setUpInnerCoupon(SetUpInnerCouponCommand.builder()
                .orderId(orderId)
                .innerCouponCustomerRelevanceIds(Lists.newArrayList(couponCustomerRelevanceId))
                .build());
        //结算订单
        this.calcOrderAmount(orderId);
    }

    @Data
    static class CalcFreePay {
        private Integer orderServeId;

        private List<Integer> serveIds = new ArrayList<>();

        private BigDecimal payPrice;
    }

    private List<OrderServe> queryCanDiscount(OrderManage orderManage, List<Integer> serveIds, Integer counponId) {

        List<Integer> freeCouponIds = discountConfigMapper.selectList(new LambdaQueryWrapper<>()).stream().map(DiscountConfig::getCouponId)
                .filter(Objects::nonNull).collect(Collectors.toList());

        //免单也是用活动价的
        if (freeCouponIds.contains(counponId)) {

            List<String> meijia = Lists.newArrayList("全手光疗延长", "单指光疗延长",
                    "精细日式卸甲（手部）", "精细日式卸甲（脚部）", "单指跳色");
            List<String> meijie = Lists.newArrayList("睫毛（卸除）", "加彩色睫毛",
                    "加种睫毛", "加彩色睫毛", "下睫毛");
            //美甲辅助服务
            List<OrderServe> meijiaSupport = orderManage.getListOrderServer().stream()
                    .filter(orderServe -> meijia.contains(orderServe.getServeName()))
                    .filter(orderServe -> orderServe.getBindInnerCoupon() == 2)
                    .filter(orderServe -> orderServe.getBindTimesCard() == 2)
                    .filter(orderServe -> orderServe.getBindOuterCoupon() == 2)
                    .filter(orderServe -> serveIds.contains(orderServe.getServeId())).collect(Collectors.toList());

            //美睫辅助服务
            List<OrderServe> meijieSupport = orderManage.getListOrderServer().stream()
                    .filter(orderServe -> meijie.contains(orderServe.getServeName()))
                    .filter(orderServe -> orderServe.getBindInnerCoupon() == 2)
                    .filter(orderServe -> orderServe.getBindTimesCard() == 2)
                    .filter(orderServe -> orderServe.getBindOuterCoupon() == 2)
                    .filter(orderServe -> serveIds.contains(orderServe.getServeId())).collect(Collectors.toList());

            //主服务
            List<OrderServe> mainServe = orderManage.getListOrderServer().stream()
                    .filter(orderServe -> !meijiaSupport.contains(orderServe))
                    .filter(orderServe -> !meijieSupport.contains(orderServe))
                    .filter(orderServe -> orderServe.getBindInnerCoupon() == 2)
                    .filter(orderServe -> orderServe.getBindTimesCard() == 2)
                    .filter(orderServe -> orderServe.getBindOuterCoupon() == 2)
                    .filter(orderServe -> serveIds.contains(orderServe.getServeId()))
                    .collect(Collectors.toList());

            List<CalcFreePay> calcFreePayList = new ArrayList<>();
            mainServe.forEach(orderServe -> {
                CalcFreePay calcFreePay = new CalcFreePay();
                calcFreePay.setOrderServeId(orderServe.getId());
                //美甲
                if (orderServe.getServeType().equals("美甲")) {
                    calcFreePay.setServeIds(meijiaSupport.stream().map(OrderServe::getId).collect(Collectors.toList()));
                    calcFreePay.setPayPrice(orderServe.getPayPrice().add(meijiaSupport.stream().map(OrderServe::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add)));
                }
                //美睫
                else if (orderServe.getServeType().equals("美睫")) {
                    calcFreePay.setServeIds(meijieSupport.stream().map(OrderServe::getId).collect(Collectors.toList()));
                    calcFreePay.setPayPrice(orderServe.getPayPrice().add(meijieSupport.stream().map(OrderServe::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add)));
                }
                //无
                else {
                    calcFreePay.setServeIds(new ArrayList<>());
                    calcFreePay.setPayPrice(orderServe.getPayPrice());
                }
                calcFreePayList.add(calcFreePay);
            });

            Optional<CalcFreePay> max = calcFreePayList.stream().max(Comparator.comparing(CalcFreePay::getPayPrice));
            return orderManage.getListOrderServer()
                    .stream()
                    .filter(orderServe ->
                            max.map(calcFreePay -> {
                                //主服务和辅助服务一起
                                calcFreePay.getServeIds().add(calcFreePay.getOrderServeId());
                                return calcFreePay.getServeIds();
                            }).orElse(new ArrayList<>())
                                    //是否包括
                                    .contains(orderServe.getId()))
                    .collect(Collectors.toList());

        } else {
            return orderManage.getListOrderServer()
                    .stream()
                    .filter(orderServe -> serveIds.contains(orderServe.getServeId()))
                    .filter(orderServe -> !orderServe.isActivity())
                    .filter(orderServe -> orderServe.getBindTimesCard() == 2)
                    .filter(orderServe -> orderServe.getBindInnerCoupon() == 2)
                    .filter(orderServe -> orderServe.getBindOuterCoupon() == 2)
                    .collect(Collectors.toList());
        }

    }

    /**
     * serviceIds 中支付金额最多的订单服务
     *
     * @param orderManage
     * @param serveIds
     * @return
     */
    private OrderServe queryMaxPayPrice(OrderManage orderManage, List<Integer> serveIds) {
        return orderManage.getListOrderServer()
                .stream()
                .filter(orderServe -> serveIds.contains(orderServe.getServeId()))
                .filter(orderServe -> !orderServe.isActivity())
                .filter(orderServe -> orderServe.getBindInnerCoupon() == 2)
                .filter(orderServe -> orderServe.getBindOuterCoupon() == 2)
                .filter(orderServe -> orderServe.getBindTimesCard() == 2)
                .max(Comparator.comparing(OrderServe::getPayPrice))
                .orElse(null);
    }


}
