package com.gogirl.shared.market;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("商城下单参数")
public class SubmitMallOrderCommand {


    @ApiModelProperty("顾客id")
    private Integer customerId;

    @ApiModelProperty("交易方式 ")
    private Integer transactionType;

    @ApiModelProperty("配送方式 1-邮寄 2-自取")
    private Integer transportMode;

    @ApiModelProperty("运费")
    private BigDecimal freight;

    @ApiModelProperty("顾客留言备注")
    private String customerRemark;

    @ApiModelProperty(value = "配送地址id", required = true)
    private Long mallCustomerAddressId;

    @ApiModelProperty("自提店铺id")
    private Integer selfTakeDepartmentId;

//    @ApiModelProperty("自提客户手机号")
//    private String selfTakePhone;

    @ApiModelProperty("自提客户手机号")
    @Deprecated
    private String phone;

    @ApiModelProperty("自提店铺地址")
    private String selfTakeDepartmentAddress;

    @ApiModelProperty("购物车id")
    private List<Long> mallShoppingCartIdList;

    /**
     * 命令执行结果 订单id
     */
    private Long executionResult;

}
