package com.gogirl.infrastructure.util;

import com.gogirl.infrastructure.common.util.ListUtil;
import com.google.common.collect.Lists;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

/**
 * Java8求笛卡尔积
 */
public class PrefixUtils {

    /**
     * 求笛卡尔积
     *
     * @param values   带求集合
     * @param supplier 结果容器
     * @param <T>      T
     * @param <C>      C
     * @return result
     */
    public static <T, C extends Collection<T>> Stream<C> ofCombinations(Collection<? extends Collection<T>> values, Supplier<C> supplier) {
        if (values.isEmpty())
            return Stream.empty();
        return Prefix.comb(new ArrayList<>(values), 0, null, supplier);
    }

    static final class Prefix<T> {
        private final T value;
        private final Prefix<T> parent;

        private Prefix(Prefix<T> parent, T value) {
            this.parent = parent;
            this.value = value;
        }

        private static <T, C extends Collection<T>> Stream<C> comb(
                List<? extends Collection<T>> values, int offset, Prefix<T> prefix,
                Supplier<C> supplier) {
            if (offset == values.size() - 1)
                return values.get(offset).stream()
                        .map(e -> new Prefix<>(prefix, e).addTo(supplier.get()));
            return values.get(offset).stream()
                    .flatMap(e -> comb(values, offset + 1, new Prefix<>(prefix, e), supplier));
        }


        // put the whole prefix into given collection
        private <C extends Collection<T>> C addTo(C collection) {
            if (parent != null)
                parent.addTo(collection);
            collection.add(value);
            return collection;
        }

    }


    static <T> void permutation(List<T> source, int i, List<List<T>> list) {
        // 如果为空
        if (ListUtil.isEmpty(source))
            return;
        // 如果i指向了最后一个字符
        if (i == source.size() - 1) {
            if (list.contains(source))
                return;
            list.add(source);
        } else {
            // i指向当前我们做排列操作的字符串的第一个字符
            for (int j = i; j < source.size(); j++) {
                // 把做排列操作的字符串的第一个字符和后面的所有字符交换
                T temp = source.get(j);
                source.set(j, source.get(i));
                source.set(i, temp);
//                obj[j] = obj[i];
//                obj[i] = temp;
                // 交换后对i后面的字符串递归做排列操作
                permutation(source, i + 1, list);
                // 每一轮结束后换回来进行下一轮排列操作
//                temp = obj[j];
                temp = source.get(j);
//                obj[j] = obj[i];
//                obj[i] = temp;
                source.set(j, source.get(i));
                source.set(i, temp);
            }
        }

    }

    public static void main(String[] args) {
        List<List<String>> lists = new ArrayList<>();
        List<String> source = Lists.newArrayList("a1", "b2", "c3");
        PrefixUtils.permutation(source, 0, lists);
        for (int i = 0; i < lists.size(); i++) {
            System.out.println(lists.get(i) + " ");
        }
    }

}
