package com.gogirl.infrastructure.util;

import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;

import java.math.BigDecimal;

public class MapDistanceUtils {

    private static double EARTH_RADIUS = 6378.137;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    /**
     * 根据两个位置的经纬度，来计算两地的距离（单位为KM）
     * 参数为String类型
     *
     * @param sourceLat 源经度
     * @param sourceLng 源纬度
     * @param targetLat 目标经度
     * @param targetLng 目标纬度
     * @return 距离单位km
     */
    public static Double getDistance(String sourceLat, String sourceLng, String targetLat, String targetLng) {

        double sourceLatDouble = Double.parseDouble(sourceLat);
        double sourceLngDouble = Double.parseDouble(sourceLng);
        double targetLatDouble = Double.parseDouble(targetLat);
        double targetLngDouble = Double.parseDouble(targetLng);


        //1、guava工具包计算距离 单位m
        GlobalCoordinates gpsFrom = new GlobalCoordinates(sourceLatDouble, sourceLngDouble);
        GlobalCoordinates gpsTo = new GlobalCoordinates(targetLatDouble, targetLngDouble);

        GeodeticCurve geoCurve = new GeodeticCalculator().calculateGeodeticCurve(Ellipsoid.WGS84, gpsFrom, gpsTo);
        double distanceMeter = geoCurve.getEllipsoidalDistance();

        //2、换算Km保留两位小数返回
        BigDecimal distanceKiloMeter = new BigDecimal(distanceMeter / 1000.0);
        return distanceKiloMeter.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
    }

}
