package com.gogirl.interfaces.product.purchase;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.product.mall.PurchaseSkuService;
import com.gogirl.domain.product.purchase.PurchaseSku;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "version3.0:商城采购sku接口", value = "version3.0:商城采购sku接口")
@RestController
@AllArgsConstructor
public class PurchaseSkuController {

    @Resource
    PurchaseSkuService purchaseSkuService;

    @ApiOperation("分页查询产品sku列表")
    @GetMapping("/technician/purchaseSku/queryPagePurchaseSku")
    public JsonResult<Page<PurchaseSku>> queryPage(@RequestHeader(required = false) String token,
                                                   @RequestParam Integer pageSize,
                                                   @RequestParam Integer pageNum,
                                                   @RequestParam(required = false) String keyword) {

        Page<PurchaseSku> page = (Page<PurchaseSku>) purchaseSkuService.queryPage(pageNum, pageSize, keyword);
        return JsonResult.success(page);
    }


    @ApiOperation("查询商品详情")
    @GetMapping("/technician/purchaseSku/getPurchaseSku")
    public JsonResult<PurchaseSku> query(@RequestHeader(required = false) String token,
                                         @RequestParam Integer purchaseSkuId) {
        PurchaseSku purchaseSku = purchaseSkuService.getPurchaseSku(purchaseSkuId);
        return JsonResult.success(purchaseSku);
    }

}
