package com.gogirl.infrastructure.interceptor;

import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.store.store.StoreManageMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Component
@AllArgsConstructor
@Slf4j
public class LoginHandlerInterceptor implements HandlerInterceptor {

    private final GogirlTokenService gogirlTokenService;
    private final StoreManageMapper storeManageMapper;
    private final CustomerMapper customerMapper;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

        String token = request.getHeader("token");

        if (request.getRequestURI().contains("no_")) {
            return true;
        }

        String sourceFrom = request.getHeader("sourceFrom");
        if (sourceFrom == null) {
            return true;
        }
        if (sourceFrom.equals("customer")) {
            GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
            if (gogirlToken == null) {
                throw new RRException(2000, "token失效，请重新登陆");
            }
//            else {
//                Customer customer = customerMapper.selectById(gogirlToken.getCustomerId());
//                if (customer != null && StringUtils.isEmpty(customer.getPhone())) {
//                    throw new RRException(1001, "请授权手机号码");
//                }
//            }
        }
        if (sourceFrom.equals("technician")) {
            GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
            if (gogirlToken == null) {
                throw new RRException(2000, "token失效，请重新登陆");
            } else {
                if (gogirlToken.getDepartmentId() == null) {
                    List<StoreManage> storeManageList = storeManageMapper.getTechnicianShopList(gogirlToken.getTechnicianId());
                    if (ListUtil.isNotEmpty(storeManageList) && storeManageList.size() == 1) {
                        StoreManage storeManage = storeManageList.get(0);
                        gogirlToken.setDepartmentId(storeManage.getId());
                        gogirlToken.setDepartmentName(storeManage.getName());
                        gogirlTokenService.updateByToken(gogirlToken);
                    } else {
                        throw new RRException(2005, "请选择店铺");
                    }
                }
            }
        }
        return true;
    }
}
