package com.gogirl.shared.market.query.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CouponDTO {

    private Integer id;

    @ApiModelProperty("卡券名称")
    private String name;

    private String couponNote;

    @ApiModelProperty("优惠金额")
    private BigDecimal discountAmount;

    @ApiModelProperty("满这个金额才能减")
    private BigDecimal reachingAmount;

    @ApiModelProperty("优惠折扣")
    private BigDecimal discountPercent;

    @ApiModelProperty("优惠券类型:1.现金抵扣券;2.免单券；3满减券；4卸甲券")
    private Integer type;

    @ApiModelProperty("使用条件:1.重叠使用")
    private String condition1;

    @ApiModelProperty("优惠券说明")
    private String note;

    @ApiModelProperty("有效期类型:1.开始和结束时间;2.有效天数")
    private Integer validType;

    @ApiModelProperty("有效天数")
    private Integer validDate;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date validStartTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date validEndTime;

    @ApiModelProperty("总数量")
    private Integer allQuantity;

    @ApiModelProperty("发放数量")
    private Integer receiveQuantity;

    @ApiModelProperty("使用次数")
    private Integer useQuantity;

    @ApiModelProperty("每人最多领取次数")
    private Integer limitQuantity;

    @ApiModelProperty("状态:1.启用;2.停止")
    private Integer state;

    @ApiModelProperty("最近更新时间,用于排序")
    private Date updateTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("客户购买该券时，实际支付的金额(用该金额算业绩)")
    private BigDecimal payAmount;

    @ApiModelProperty("7:大众点评收款,10:免单(外部券购买时钱去到哪里了和customer_balance_record表的source字段保持一致)")
    private String paySource;

    @ApiModelProperty("0 = 内部券 1 = 外部券")
    private Integer sourceType;
}
