package com.gogirl.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.order.serve.ScheduleServe;
import com.gogirl.domain.user.customer.Customer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class IdleTimeProgramQuery {


    private Integer id;

    //修改预约的时候,修改前的id
    @ApiModelProperty("修改预约的时候,修改前的id")
    private Integer oldId;

    @ApiModelProperty("预约订单号")
    private String scheduledNo;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("预约时间")
    private Date scheduledTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("最近修改时间")
    private Date lastUpdateTime;

    @ApiModelProperty("下单人id")
    private Integer scheduledUser;

    @ApiModelProperty("店铺端预约用户名")
    private String storeScheduleUsername;

    @ApiModelProperty("店铺端预约手机号码")
    private String telephone;

    @ApiModelProperty("预约到达时间字符串")
    private String arriveTimeString;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("预约到达时间")
    private Date arriveTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("上次服务时间")
    private Date lastServiceTime;

    @ApiModelProperty("到店人")
    private String arriveUser;

    @ApiModelProperty("下单店铺id")
    private Integer departmentId;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("删除备注")
    private String delRemaerk;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开单时间")
    private Date openbillTime;

    @ApiModelProperty("已预约#1  失约#2  守约#3  已取消#4 已删除#5")
    private Integer status;

    @ApiModelProperty("创建人")
    private String createUser;

    @ApiModelProperty("店铺名称")
    private String departmentName;

    @ApiModelProperty("删除服务字段")
    private String deleteServe;

    @ApiModelProperty("id")
    private Integer scheduledType;

    @ApiModelProperty("提醒类型")
    private Integer remindStatus;

    @ApiModelProperty("已读状态")
    private Integer isRead;

    @ApiModelProperty("统计开始时间")
    private String startTime;

    @ApiModelProperty("统计结束时间")
    private String endTime;

    @ApiModelProperty("分页查询当天预约")
    private String sameDayTime;

    @ApiModelProperty("发送服务通知需要的formId")
    private String formId;

    /**
     * 非数据库字段
     */
    @TableField(exist = false)
    @ApiModelProperty("token")
    private String token;


    @TableField(exist = false)
    @ApiModelProperty("预约时间")
    private String scheduleDate;

    @TableField(exist = false)
    @ApiModelProperty("预约下服务列表")
    private List<ScheduleServe> listScheduleServer;

    @TableField(exist = false)
    @ApiModelProperty("预约用户信息")
    private Customer customer;


}
