package com.gogirl.application.user.customer;

import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.user.customer.CustomerBalance;
import com.gogirl.domain.user.customer.CustomerBalanceRecord;
import com.gogirl.shared.user.command.ConsumerCommand;

import java.util.List;

public interface CustomerBalanceService extends IService<CustomerBalance> {

    /**
     * 查询用户余额
     *
     * @param customerId 用户id
     * @return 用户会员卡
     */
    CustomerBalance getCustomerBalance(int customerId);


    /**
     * 查看消费记录
     *
     * @param param param
     * @return list
     */
    List<CustomerBalanceRecord> getBalanceRecordCard(CustomerBalanceRecord param);


    /**
     * 余额消费
     *
     * @param consumerCmd
     */
    void consumer(ConsumerCommand consumerCmd);
}
