package com.gogirl.interfaces.user;

import com.gogirl.application.user.customer.CustomerService;
import com.gogirl.dto.customer.CustomerOrderDetail;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = {"用户相关接口"}, value = "用户相关接口")
@RestController
@AllArgsConstructor
@Slf4j
public class CustomerController {
    private final CustomerService customerService;


    @ApiOperation(value = "查询用户可选年龄段")
    @PostMapping("/technician/getAgeGroups")
    public JsonResult<List<String>> getAgeGroups() {
        List<String> ageGroups = customerService.getAgeGroups();
        return JsonResult.success(ageGroups);
    }

    @ApiOperation(value = "用户详情数据查看")
    @PostMapping("/technician/queryCustomerDetail")
    public JsonResult<CustomerOrderDetail> queryCustomerDetail(@RequestHeader String token,
                                                               @RequestParam Integer customerId,
                                                               @RequestParam(required = false) Integer orderId) {

        CustomerOrderDetail customerOrderDetail = customerService.queryCustomerDetail(customerId, orderId);
        return JsonResult.success(customerOrderDetail);
    }

    @ApiOperation(value = "用户详情数据修改")
    @PostMapping("/technician/updateCustomerDetail")
    public JsonResult<Void> updateCustomerDetail(@RequestHeader String token,
                                                 @RequestParam(required = false) Integer birthdayMonth,
                                                 @RequestParam(required = false) Integer birthdayDay,
                                                 @RequestParam(required = false) String ageGroup,
                                                 @RequestParam Integer customerId,
                                                 @RequestParam(required = false) Integer orderId,
                                                 @RequestParam(required = false) Integer orderServeId,
                                                 @RequestParam(required = false) String storeRecordRealName,
                                                 @RequestParam(required = false) String sex,
                                                 @RequestParam(required = false) Integer age,
                                                 @RequestParam(required = false) String job,
                                                 @RequestParam(required = false) String preference,
                                                 @RequestParam(required = false) String character,
                                                 @RequestParam(required = false) Integer customerSource) {
        customerService.updateCustomerDetail(birthdayMonth, birthdayDay, ageGroup, customerId, orderId, orderServeId, storeRecordRealName, sex, age, job, preference, character, customerSource);
        return JsonResult.success();
    }

    @ApiOperation(value = "h5用户登录")
    @GetMapping("/customer/no_h5Login")
    public JsonResult<String> h5Login(@RequestParam Integer orderId) {
        String token = customerService.h5Login(orderId);
        return JsonResult.success(token);
    }
}
