package com.gogirl.domain.xcx;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.user.Customer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@ApiModel("token封装")
@Builder
@Data
@TableName("gogirl_token")
@AllArgsConstructor
@NoArgsConstructor
public class GogirlToken {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("1：客户端小程序，2：美甲师端小程序")
    private Integer sysId;

    @ApiModelProperty("用户id或者美甲师关联的ssa.id")
    private Integer customerId;

    @ApiModelProperty("接口调用凭证")
    private String token;

    @ApiModelProperty("手机验证码")
    private String code;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("上次更新时间")
    private Date updateTime;

    @ApiModelProperty("美甲师openid")
    private String openid;

    @ApiModelProperty("小程序session_key")
    private String sessionKey;

    private String unionid;

    private String phone;

    @TableField(exist = false)
    @ApiModelProperty("客户实体对象")
    private Customer customer;

    @TableField(exist = false)
    @ApiModelProperty("美甲师实体对象")
    private StoreTechnician StoreTechnician;

}
