package com.gogirl.application.xcx.impl;


import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.mapper.xcx.GogirlTokenMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Date;


@Service
@AllArgsConstructor
public class GogirlTokenServiceImpl implements GogirlTokenService {


    private final GogirlTokenMapper gogirlTokenMapper;


    @Override
    public GogirlToken getTokenByToken(String token) {
        return gogirlTokenMapper.selectByToken(token);

    }

    @Override
    public GogirlToken getTokenByToken_t(String token) {
        return gogirlTokenMapper.selectByToken_t(token);

    }

    @Override
    public int updateByPrimaryKeySelective(GogirlToken record) {
        record.setUpdateTime(new Date());
        return gogirlTokenMapper.updateByPrimaryKeySelective(record);
    }
}
