package com.gogirl.interfaces.store.career;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.store.store.CareerCmdService;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.store.career.CareerWorks;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.common.util.lock.WorkLock;
import com.gogirl.shared.store.SubmitWorksCommand;
import com.gogirl.shared.store.WorksQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-07-14
 */
@Api(tags = "美甲师作品接口")
@RestController
public class CareerWorksController {

    @Resource
    CareerCmdService careerCmdService;

    @ApiOperation("提交美甲作品")
    @PostMapping("/technician/career/submitWorks")
    public JsonResult<Void> submitWorks(@RequestBody @Valid SubmitWorksCommand cmd) {
        Integer technicianId = SessionUtils.getTechnicianId();
        WorkLock workLock = WorkLock.getInstance();
        try {
            workLock.lock(technicianId);
            cmd.setTechnicianId(technicianId);
            careerCmdService.submitWorks(cmd);
            return JsonResult.success();
        } finally {
            workLock.unlock(technicianId);
        }
    }


    @ApiOperation("获取美甲师需要打板的款式")
    @GetMapping("/technician/career/queryWorkTpl")
    public JsonResult<Page<BaseProduce>> queryWorkTpl(@RequestParam Integer pageNum,
                                                      @RequestParam Integer pageSize,
                                                      @RequestParam(required = false) String searchKeyWord) {
        Integer technicianId = SessionUtils.getTechnicianId();
        Page<BaseProduce> baseProduceList = careerCmdService.queryWorkTpl(technicianId, pageNum, pageSize, searchKeyWord);
        return JsonResult.success(baseProduceList);
    }

    @ApiOperation(("查询美甲师作品"))
    @PostMapping("/technician/career/queryWorks")
    public JsonResult<Page<CareerWorks>> queryWorks(@RequestBody WorksQuery qry) {
        Integer technicianId = SessionUtils.getTechnicianId();
        qry.setTechnicianId(technicianId);
        IPage<CareerWorks> worksIPage = careerCmdService.queryWorks(qry);
        return JsonResult.success((Page<CareerWorks>) worksIPage);
    }
}
