package com.gogirl.domain.store.oa;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.gogirl.domain.store.store.StoreTechnician;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@ApiModel("请假申请")
@Data
@TableName("take_leave_event")
public class TakeLeaveEvent {

    /**
     * status
     */
    public static final Integer STATUS_UN_APPROVAL = 1;
    public static final Integer STATUS_APPROVAL_PASS = 2;
    public static final Integer STATUS_APPROVAL_REFUSE = 3;
    /**
     * type
     */
    public static final Integer TYPE_OVER_TIME = 1;
    public static final Integer TYPE_ADJUST_REST = 2;
    public static final Integer TYPE_PERSONAL_REST = 3;
    public static final Integer TYPE_ILL_REST = 4;
    public static final Integer TYPE_OUT = 5;
    public static final Integer TYPE_MARRY = 6;

    @TableId(type = IdType.AUTO)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("请假美甲师id")
    private Integer applyTechnicianId;

    @ApiModelProperty("1-加班 2-调休 3-事假 4-病假 5-外出 6-婚假")
    private Integer type;

    @ApiModelProperty("开始时间")
    private Long startTime;

    @ApiModelProperty("结束时间")
    private Long endTime;

    @ApiModelProperty("请假时长")
    private BigDecimal timeLength;

    @ApiModelProperty("申请理由")
    private String applyReason;

    @ApiModelProperty("拒绝理由")
    private String rejectReason;

    @ApiModelProperty("拒绝的美甲师id")
    private String rejectTechnicianId;

    @ApiModelProperty("拒绝的美甲师id")
    private String rejectTechnicianName;

    @ApiModelProperty("处理中的美甲师id")
    private Integer dealingTechnicianId;
    @ApiModelProperty("处理中的美甲师姓名")
    private String dealingTechnicianName;

    @ApiModelProperty("1-待审批 2-审批通过 3-审批拒绝")
    private Integer status;

    private Long createTime;

    @TableField(exist = false)
    private StoreTechnician applyStoreTechnicianDTO;

    @TableField(exist = false)
    private String applyTechnicianName;

}
