package com.bailuntec.job;

import com.bailuntec.domain.constant.CommonConstant;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.mapper.DcBaseOmsSku30Mapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSession;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

@Slf4j
public class OrderSyncJob30 extends PointJob {

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        String queryTime = DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(LocalDate.now());

        SqlSession sqlSession = SessionUtil.getFactory().openSession(true);
        DcBaseOmsSku30Mapper dcBaseOmsSku30Mapper = sqlSession.getMapper(DcBaseOmsSku30Mapper.class);
        try {
//            dcBaseOmsSku30Mapper.truncateTable();
            dcBaseOmsSku30Mapper.upsertByOmsSku(queryTime);
        } finally {
            sqlSession.close();
        }
    }
}
