package com.bailuntec.balancesheet.mapper;

import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.Date;


@Repository
public interface DcFixedAssetsDetailMapper {
    /**
     * 生成昨天 固定资产 期初期末 一级明细初始化数据
     * @param lastDay
     * @param twoDaysBefore
     */
    @Insert("insert into dc_fixed_assets_detail(day,company_value,company_name,start_amount,debit_amount,credit_amount,end_amount) " +
            "select #{lastDay},a.company_value,a.company,ifnull(b.end_amount,0) startAmount,sum(ifnull(c.amount,0)) debitAmount,0," +
            "ifnull(b.end_amount,0) + sum(ifnull(c.amount,0)) endAmount " +
            "from (select distinct company_value,company from dc_base_buy where day <= #{lastDay}) a " +
            "left join (select company_value,end_amount from dc_fixed_assets_detail where day = #{twoDaysBefore}) b on a.company_value = b.company_value " +
            "left join (select company_value,amount from dc_base_buy where day = #{lastDay}) c " +
            "on a.company_value = c.company_value group by a.company_value")
    void insertFixedAssetsDetail(@Param("lastDay") Date lastDay, @Param("twoDaysBefore") Date twoDaysBefore);

    /**
     * 其他应收款
     * @return
     */
    @Select("select sum(end_amount) from dc_fixed_assets_detail where day = #{lastDay}")
    BigDecimal getFixedAssetsSum(@Param("lastDay") Date lastDay);

}
