package com.bailuntec;

import com.alibaba.druid.pool.DruidDataSource;
import com.bailuntec.job.FbaStockJob;
import com.bailuntec.job.WmsLogisticsJob;
import com.bailuntec.job.WmsLogisticsReconciliationJob;
import com.bailuntec.job.WmsStockJob;
import com.bailuntec.listener.FbaStockListener;
import com.bailuntec.listener.WmsStockListener;
import com.bailuntec.utils.PropertiesUtil;
import com.dangdang.ddframe.job.config.JobCoreConfiguration;
import com.dangdang.ddframe.job.config.simple.SimpleJobConfiguration;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.event.rdb.JobEventRdbConfiguration;
import com.dangdang.ddframe.job.lite.api.JobScheduler;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperConfiguration;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperRegistryCenter;
import lombok.extern.slf4j.Slf4j;

import javax.sql.DataSource;

@Slf4j
public class Application {
    private static PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("job");
    private static final String EVENT_RDB_STORAGE_DRIVER = propertiesUtil.getPropertyAsString("EVENT_RDB_STORAGE_DRIVER");
    private static final String EVENT_RDB_STORAGE_URL = propertiesUtil.getPropertyAsString("EVENT_RDB_STORAGE_URL");
    private static final String EVENT_RDB_STORAGE_USERNAME = propertiesUtil.getPropertyAsString("EVENT_RDB_STORAGE_USERNAME");
    private static final String EVENT_RDB_STORAGE_PASSWORD = propertiesUtil.getPropertyAsString("EVENT_RDB_STORAGE_PASSWORD");
    public static void main(String[] args) {
        new JobScheduler(createRegistryCenter(),createJobConfiguration(),createJobEventConfiguration(),new FbaStockListener()).init();
        new JobScheduler(createRegistryCenter(),createJobConfiguration1(),createJobEventConfiguration(),new WmsStockListener()).init();
        new JobScheduler(createRegistryCenter(),createJobConfiguration2()).init();
        new JobScheduler(createRegistryCenter(),createJobConfiguration3()).init();
    }

    private static CoordinatorRegistryCenter createRegistryCenter() {
         CoordinatorRegistryCenter regCenter = new ZookeeperRegistryCenter(new ZookeeperConfiguration(propertiesUtil.getPropertyAsString("ZOOKEEPER_SERVER"), propertiesUtil.getPropertyAsString("NAME_SPACE")));
        regCenter.init();
        return regCenter;
    }

    private static LiteJobConfiguration createJobConfiguration() {
        JobCoreConfiguration simpleCoreConfig = JobCoreConfiguration.newBuilder(propertiesUtil.getPropertyAsString("JOB_NAME_FBA"), propertiesUtil.getPropertyAsString("JOB_CRON_FBA"), propertiesUtil.getPropertyAsInt("SHARDING_TOTAL_COUNT")).build();
        SimpleJobConfiguration simpleJobConfig = new SimpleJobConfiguration(simpleCoreConfig, FbaStockJob.class.getCanonicalName());
        LiteJobConfiguration simpleJobRootConfig = LiteJobConfiguration.newBuilder(simpleJobConfig).build();
        return simpleJobRootConfig;
    }

    private static LiteJobConfiguration createJobConfiguration1() {
        JobCoreConfiguration simpleCoreConfig = JobCoreConfiguration.newBuilder(propertiesUtil.getPropertyAsString("JOB_NAME_WMS"), propertiesUtil.getPropertyAsString("JOB_CRON_WMS"), propertiesUtil.getPropertyAsInt("SHARDING_TOTAL_COUNT")).build();
        SimpleJobConfiguration simpleJobConfig = new SimpleJobConfiguration(simpleCoreConfig, WmsStockJob.class.getCanonicalName());
        LiteJobConfiguration simpleJobRootConfig = LiteJobConfiguration.newBuilder(simpleJobConfig).build();
        return simpleJobRootConfig;
    }

    private static LiteJobConfiguration createJobConfiguration2() {
        JobCoreConfiguration simpleCoreConfig = JobCoreConfiguration.newBuilder(propertiesUtil.getPropertyAsString("JOB_NAME_LOGISTICS"), propertiesUtil.getPropertyAsString("JOB_CRON_LOGISTICS"), propertiesUtil.getPropertyAsInt("SHARDING_TOTAL_COUNT")).build();
        SimpleJobConfiguration simpleJobConfig = new SimpleJobConfiguration(simpleCoreConfig, WmsLogisticsJob.class.getCanonicalName());
        LiteJobConfiguration simpleJobRootConfig = LiteJobConfiguration.newBuilder(simpleJobConfig).build();
        return simpleJobRootConfig;
    }

    private static LiteJobConfiguration createJobConfiguration3() {
        JobCoreConfiguration simpleCoreConfig = JobCoreConfiguration.newBuilder(propertiesUtil.getPropertyAsString("JOB_NAME_LOGISTICS_RECONCILIATION"), propertiesUtil.getPropertyAsString("JOB_CRON_LOGISTICS_RECONCILIATION"), propertiesUtil.getPropertyAsInt("SHARDING_TOTAL_COUNT")).build();
        SimpleJobConfiguration simpleJobConfig = new SimpleJobConfiguration(simpleCoreConfig, WmsLogisticsReconciliationJob.class.getCanonicalName());
        LiteJobConfiguration simpleJobRootConfig = LiteJobConfiguration.newBuilder(simpleJobConfig).build();
        return simpleJobRootConfig;
    }

    private static JobEventConfiguration createJobEventConfiguration() {
        JobEventConfiguration jobEventRdbConfig = new JobEventRdbConfiguration(setUpEventTraceDataSource());
        return jobEventRdbConfig;
    }

    private static DataSource setUpEventTraceDataSource() {
        DruidDataSource result = new DruidDataSource();
        result.setDriverClassName(EVENT_RDB_STORAGE_DRIVER);
        result.setUrl(EVENT_RDB_STORAGE_URL);
        result.setUsername(EVENT_RDB_STORAGE_USERNAME);
        result.setPassword(EVENT_RDB_STORAGE_PASSWORD);
        return result;
    }

}
