package com.bailuntec.job;

import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ProcSyncDataWareHouseJob implements SimpleJob {
    @Override
    public void execute(ShardingContext shardingContext) {
        try {
            DcBaseStockMapper mapper = SessionUtil.getSession().getMapper(DcBaseStockMapper.class);
            mapper.procSyncDataWareHouse();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MYBATIS操作DB调用ProcSyncDataWareHouseJob存储过程失败", e);
        } finally {
            SessionUtil.closeSession();
        }
    }
}
