import com.bailuntec.domain.entity.DcBaseCostFirst;
import com.bailuntec.domain.example.DcBaseCostFirstExample;
import com.bailuntec.domain.pojo.CostFirstOrder;
import com.bailuntec.job.CalculateCostFirstJob;
import com.bailuntec.listener.CalculateCostFirstListener;
import com.bailuntec.mapper.DcBaseCostFirstMapper;
import com.bailuntec.mapper.DcMidCostFirstMapper;
import com.bailuntec.utils.SessionUtil;
import org.junit.jupiter.api.Test;

import java.util.List;

public class CostFirstTest {
    @Test
    public void test() {
        CalculateCostFirstJob costFirstJob = new CalculateCostFirstJob();
        try {
            DcBaseCostFirstMapper dcBaseCostFirstMapper = SessionUtil.getSession().getMapper(DcBaseCostFirstMapper.class);
            //拿到物流单号, 将物流单中每个SKU的费用算出来
            List<CostFirstOrder> channelOrderIdList = dcBaseCostFirstMapper.listChannelOrderId(200, 2);
            if (channelOrderIdList != null && channelOrderIdList.size() > 0) {
                for (CostFirstOrder costFirstOrder : channelOrderIdList) {
                    DcBaseCostFirstMapper dcBaseCostFirstMapperFor = SessionUtil.getSession().getMapper(DcBaseCostFirstMapper.class);
                    List<DcBaseCostFirst> dcBaseCostFirsts = dcBaseCostFirstMapperFor.selectByExample(DcBaseCostFirstExample.newAndCreateCriteria().andChannelOrderIdEqualTo(costFirstOrder.getChannelOrderId()).andTransferOrderIdEqualTo(costFirstOrder.getTransferOrderId()).example());
                    costFirstJob.handleChannelOrderSku(dcBaseCostFirsts);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MYBATIS操作DB失败", e);
        } finally {
            SessionUtil.closeSession();
        }
        CalculateCostFirstListener calculateCostFirstListener = new CalculateCostFirstListener();
        calculateCostFirstListener.afterJobExecuted(null);
    }
    @Test
    public void  test1() {
        CalculateCostFirstListener calculateCostFirstListener = new CalculateCostFirstListener();
        calculateCostFirstListener.afterJobExecuted(null);
    }
}
