package com.bailuntec.job;

import com.bailuntec.domain.entity.DcBaseStock;
import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.util.List;

@Slf4j
public class DailyStockJob implements SimpleJob {
    @Override
    public void execute(ShardingContext shardingContext) {
        int pageIndex = 1;
        int pageSize = 1000;
        try {
            DcBaseStockMapper mapper = SessionUtil.getSession().getMapper(DcBaseStockMapper.class);
            Integer pickage = mapper.selectStockCount();
            Integer stockPage = pickage % pageSize == 0 ? pickage/pageSize : pickage/pageSize + 1;
            do{
                List<DcBaseStock> dcBaseStockList = mapper.selectStock((pageIndex - 1) * pageSize, pageSize);
                for(DcBaseStock dcBaseStock : dcBaseStockList) {
                    log.warn("bailunSku: " + dcBaseStock.getBailunSku() + "  unionPrice:" + dcBaseStock.getUnitPrice());
                    if(dcBaseStock.getUnitPrice() == null) {
                        dcBaseStock.setUnitPrice(BigDecimal.ZERO);
                    }
                    DcBaseStockMapper dcBaseStockMapper = SessionUtil.getSession().getMapper(DcBaseStockMapper.class);
                    dcBaseStockMapper.insertDailyStock(dcBaseStock);
                }
                pageIndex = pageIndex + 1;
            }while(pageIndex <= stockPage);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MYBATIS操作DB失败", e);
        } finally {
            SessionUtil.closeSession();
        }
    }
}
