package com.bailuntec.balancesheet.mapper;

import com.bailuntec.balancesheet.dto.SemiPurchaseDetailDTO;
import com.bailuntec.balancesheet.dto.SemiStockLogDTO;
import org.apache.ibatis.annotations.Insert;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface DcSemiPurchaseDetailMapper {
    @Insert("<script>" +
            "insert into dc_semi_purchase_detail(buy_id,detail_id,buy_no,supplier_id,supplier_name,sku_code,sku_name,warehouse_id,warehouse_name,transfer_quantity," +
            "unit_price,semi_update_date,sku_del_status,purchase_del_status) values" +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.buyId},#{item.detailId},#{item.buyNo},#{item.supplierId},#{item.supplierName},#{item.skuCode},#{item.skuName},#{item.warehouseId},#{item.warehouseName}," +
            "#{item.transferQuantity},#{item.unitPrice},#{item.semiUpdateDate},#{item.skuDelStatus},#{item.purchaseDelStatus})" +
            "</foreach>" +
            " on duplicate key update buy_id=values(buy_id),buy_no=values(buy_no),supplier_id=values(supplier_id),supplier_name=values(supplier_name)," +
            "sku_code=values(sku_code),sku_name=values(sku_name),warehouse_id=values(warehouse_id),warehouse_name=values(warehouse_name)," +
            "transfer_quantity=values(transfer_quantity),unit_price=values(unit_price),semi_update_date=values(semi_update_date),sku_del_status=values(sku_del_status)," +
            "purchase_del_status=values(purchase_del_status)" +
            "</script>")
    void insertOrUpdateSemiPurchaseDetail(List<SemiPurchaseDetailDTO> semiPurchaseDetailDTOList);
}