package com.bailuntec.domain.pojo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class SkuInfo {
    /// <summary>
    /// 产品主键
    /// </summary>
    @JSONField(name = "id")
    public Integer skumsId;

    /// <summary>
    /// 商品主键
    /// </summary>
    public Integer mainId;

    /// <summary>
    /// 内部商品编码
    /// </summary>
    @JSONField(name = "skuCode")
    public String productInnerCode;

    /// <summary>
    /// 内部产品编码
    /// </summary>
    @JSONField(name = "productCode")
    public String bailunInnerSku;

    /// <summary>
    /// 商品编码
    /// </summary>
    @JSONField(name = "product")
    public String productCode;

    /// <summary>
    /// 产品编码
    /// </summary>
    @JSONField(name = "sku")
    public String bailunSku;

    /// <summary>
    /// 中文名称
    /// </summary>
    @JSONField(name = "cTitle")
    public String skuTitleCn;

    /// <summary>
    /// 英文名称
    /// </summary>
    @JSONField(name = "eTitle")
    public String skuTitleEn;

    /// <summary>
    /// 分类Id
    /// </summary>
    @JSONField(name = "categoryId")
    public Integer categoryId;


    /// <summary>
    /// 分类名称
    /// </summary>
    @JSONField(name = "categoryName")
    public String categoryName;

    /// <summary>
    /// 百伦分类Id
    /// </summary>
    @JSONField(name = "categoryBailunId")
    public Integer bailunCategoryId;

    /// <summary>
    /// 百伦分类名称
    /// </summary>
    @JSONField(name = "categoryBailunName")
    public String bailunCategoryName;

    /// <summary>
    /// 主图
    /// </summary>
    @JSONField(name = "mainImage")
    public String skuImage;

    /// <summary>
    /// 尺码图片
    /// </summary>
    public String sizeImage;

    /// <summary>
    /// 是否成品
    /// </summary>
    @JSONField(name = "isFinish")
    public Integer type;

    /// <summary>
    /// 颜色
    /// </summary>
    @JSONField(name = "color")
    public String color;

    /// <summary>
    /// 规格
    /// </summary>
    @JSONField(name = "size")
    public String specifications;

    /// <summary>
    /// 采购价
    /// </summary>
    @JSONField(name = "unitPrice")
    public BigDecimal unitPrice;

    /// <summary>
    /// 长,单位cm
    /// </summary>
    @JSONField(name = "length")
    public BigDecimal length;

    /// <summary>
    /// 宽,单位cm
    /// </summary>
    @JSONField(name = "width")
    public BigDecimal width;

    /// <summary>
    /// 高,单位cm
    /// </summary>
    @JSONField(name = "height")
    public BigDecimal height;

    /// <summary>
    /// 币种
    /// </summary>
    @JSONField(name = "currency")
    public String currency;

    /// <summary>
    /// 产品重量,单位g
    /// </summary>
    @JSONField(name = "weight")
    public BigDecimal weight;

    /// <summary>
    /// 单位
    /// </summary>
    public String unit;

    /// <summary>
    /// 包装重量
    /// </summary>
    public BigDecimal packingWeight;

    /// <summary>
    /// 产品尺寸
    /// </summary>
    public String productSize;

    /// <summary>
    /// 包装尺寸
    /// </summary>
    public String packingSize;

    /// <summary>
    /// 包装名称
    /// </summary>
    public String packingName;

    /// <summary>
    /// 包装价格
    /// </summary>
    public BigDecimal packingPrice;

    /// <summary>
    /// 充电器规格
    /// </summary>
    public Integer chargerSpecifications;

    /// <summary>
    /// 产品性质
    /// </summary>
    public String productNature;

    /// <summary>
    /// 中文配货名
    /// </summary>
    public String pickTitleCn;

    /// <summary>
    /// 英文配货名
    /// </summary>
    public String pickTitleEn;

    /// <summary>
    /// 中文申报名
    /// </summary>
    public String declareTitleCn;

    /// <summary>
    /// 英文申报名
    /// </summary>
    public String declareTitleEn;

    /// <summary>
    /// 海关编码
    /// </summary>
    public String customsCode;

    /// <summary>
    /// 业务开发员Id
    /// </summary>
    @JSONField(name = "bussinessId")
    public Integer bussinessId;

    /// <summary>
    /// 业务开发员名称
    /// </summary>
    @JSONField(name = "bussinessName")
    public String bussinessName;

    /// <summary>
    /// 销售员Id -- 穗海说的,销售员和业务开发员是一个字段
    /// </summary>
    @JSONField(name = "sellerId")
    public Integer sellerId;

    /// <summary>
    /// 销售员名称 - 暂缺 -- 穗海说的,销售员和业务开发员是一个字段
    /// </summary>
    @JSONField(name = "sellerName")
    public String sellerName;

    /// <summary>
    /// 找货员
    /// </summary>
    @JSONField(name = "bargainer")
    public String bargainer;

    /// <summary>
    /// 采购员Id
    /// </summary>
    @JSONField(name = "buyerId")
    public Integer buyerId;

    /// <summary>
    /// 采购员名称
    /// </summary>
    @JSONField(name = "buyerName")
    public String buyerName;


    /// <summary>
    /// 贴标要求
    /// </summary>
// @JSONField(name = "")
    public String labelReq;

    /// <summary>
    /// 质检要求
    /// </summary>
// @JSONField(name = "")
    public String zhijianReq;

    /// <summary>
    /// 质检工时
    /// </summary>
    public BigDecimal inspectionHours;

    /// <summary>
    /// 商品状态 1停售，2在售
    /// </summary>
    @JSONField(name = "status")
    public Integer status;

    /// <summary>
    /// 推送产品库状态 1推送
    /// </summary>
    @JSONField(name = "productStatus")
    public Integer pushStatus;

    /// <summary>
    /// 是否启用
    /// </summary>
    @JSONField(name = "enable")
    public Integer enable;

    /// <summary>
    /// 上传状态 0未上传，1已上传
    /// </summary>
    public Integer isUpApi;

    /// <summary>
    /// 同步状态 0未同步，1已同步，-1同步失败
    /// </summary>
    public Integer lastUpdateState;

    /// <summary>
    /// 同步失败原因
    /// </summary>
// @JSONField(name = "")
    public String reason;

    /// <summary>
    /// 虚拟采购价
    /// </summary>
    public BigDecimal virtualPrice;

    /// <summary>
    /// 销售价格
    /// </summary>
    @JSONField(name = "salesPrice")
    public BigDecimal salesPrice;

    /// <summary>
    /// 供应商Id
    /// </summary>
    @JSONField(name = "suppliersId")
    public Integer suppliersId;

    /// <summary>
    /// 供应商名称
    /// </summary>
    @JSONField(name = "suppliersName")
    public String suppliersName;

    /// <summary>
    /// 供应商链接
    /// </summary>
    @JSONField(name = "suppliersLink")
    public String suppliersLink;

    /// <summary>
    /// 最小订单量
    /// </summary>
    @JSONField(name = "moq")
    public Integer moq;

    /// <summary>
    /// 内部最小订单量
    /// </summary>
    @JSONField(name = "internalMoq")
    public Integer internalMoq;

    /// <summary>
    /// 交期
    /// </summary>
    @JSONField(name = "suppliersDelivery")
    public Integer supplierDelivery;

    /// <summary>
    /// 备注
    /// </summary>
    public String remark;

    /// <summary>
    /// 组合关系
    /// </summary>
    public String GroupRelete;

    /// <summary>
    /// 更新人
    /// </summary>
    @JSONField(name = "updateName")
    public String updateName;

    /// <summary>
    /// 更新时间
    /// </summary>
    @JSONField(name = "updateTime")
    public LocalDateTime updateTime;

    /// <summary>
    /// 创建人
    /// </summary>
    @JSONField(name = "createName")
    public String createName;

    /// <summary>
    /// 创建时间
    /// </summary>
    @JSONField(name = "createTime")
    public LocalDateTime createTime;

    /// <summary>
    /// PDS推送产品库时间
    /// </summary>
    @JSONField(name = "pushTime")
    public LocalDateTime pushTime;

    /// <summary>
    /// PDS开发时间
    /// </summary>
    @JSONField(name = "developTime")
    public LocalDateTime developTime;

    /// <summary>
    /// 调拨计划交期
    /// </summary>
    @JSONField(name = "allotDelivery")
    public Integer transferDelivery;


    /// <summary>
    /// 开发来源:1线上,2线下,3美容线下,4线下供应商推荐,5登宇服装,6线上供应商,7服装,8.
    //9.万邑通分销,10.托尼斯
    /// </summary>
    @JSONField(name = "source")
    public Integer source;


    /// <summary>
    /// 是否删除
    /// </summary>
    @JSONField(name = "isDeleted")
    public Boolean hasDelete;

    /// <summary>
    /// 公司Id
    /// </summary>
    @JSONField(name = "creatorOrganizeId")
    public Integer companyId;

    /// <summary>
    /// 对应发货仓列表
    /// </summary>
    @JSONField(name = "wareList")
    public List<WarehouseInfo> warehouseList;

    public Integer categorySimpleId;

    public String categorySimpleName;

    public String brand;

    private Integer productType;

    private String productTypeDesc;
}
