package com.bailuntec.controller;

import com.bailuntec.domain.entity.DcBaseSku;
import com.bailuntec.domain.entity.DcDailySales;
import com.bailuntec.domain.pojo.DcDailySalesVO;
import com.bailuntec.domain.pojo.ResponseResult;
import com.bailuntec.service.SalesService;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.List;

@RestController
@Slf4j
public class SalesController {
    @Autowired
    private SalesService salesService;
    @RequestMapping("/sales/daily")
    public ResponseResult getDailySales(@RequestParam("skus") String skus, HttpServletRequest request) {
        if (StringUtils.isEmpty(skus)) {
            return new ResponseResult<>(LocalDateTime.now(), HttpStatus.MULTIPLE_CHOICES.value(), null, "SKU不能为null", request.getServletPath(), null);
        }
        try {
            List<DcDailySalesVO> dcSkuListInfo = salesService.listSkus(skus);
            return new ResponseResult<>(LocalDateTime.now(), HttpStatus.OK.value(), null, null, request.getServletPath(), dcSkuListInfo);
        } catch (Exception e) {
            log.error("获取销量信息错误" + skus, e);
            return new ResponseResult(LocalDateTime.now(), HttpStatus.BAD_REQUEST.value(), e.getMessage(), null, request.getServletPath(), null);
        }
    }
}
