package com.bailuntec;

import com.bailuntec.domain.entity.DcBaseStock;
import com.bailuntec.domain.entity.DcBaseStockRecord;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.DcBaseStockExample;
import com.bailuntec.domain.example.DcBaseStockRecordExample;
import com.bailuntec.job.CalculateStockRecordJob;
import com.bailuntec.job.SyncWarehouseStockJob;
import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.mapper.DcBaseStockRecordMapper;
import com.bailuntec.utils.SessionUtil;
import org.junit.jupiter.api.Test;

import java.time.LocalDateTime;
import java.util.List;

public class ApplicationTest {

    @Test
    public void syncStock() {
        DcBaseStockMapper dcBaseStockMapper = SessionUtil.getSession().getMapper(DcBaseStockMapper.class);
        List<DcBaseStock>  dcBaseStockList = dcBaseStockMapper.selectByExample(DcBaseStockExample.newAndCreateCriteria().andUpdateTimeLessThan(LocalDateTime.of(2019, 9, 10, 00, 00, 00)).example());
        for(DcBaseStock dcBaseStock : dcBaseStockList) {
            try {
                DcBaseStockRecord dcBaseStockRecord = new DcBaseStockRecord();
                dcBaseStockRecord.setStockTime(dcBaseStock.getUpdateTime());
                dcBaseStockRecord.setBailunSku(dcBaseStock.getBailunSku());
                dcBaseStockRecord.setWarehouseCode(dcBaseStock.getWarehouseCode());
                dcBaseStockRecord.setQuantityStock(dcBaseStock.getUsableStock());
                DcBaseStockRecordMapper mapper = SessionUtil.getSession().getMapper(DcBaseStockRecordMapper.class);
                int i = mapper.updateByExampleSelective(dcBaseStockRecord, DcBaseStockRecordExample.newAndCreateCriteria().andBailunSkuEqualTo(dcBaseStockRecord.getBailunSku()).andWarehouseCodeEqualTo(dcBaseStockRecord.getWarehouseCode()).andStockTimeEqualTo(dcBaseStockRecord.getStockTime()).example());
                if (i == 0) {
                    mapper.insertSelective(dcBaseStockRecord);
                }
            } catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("MYbatis操作DB失败", e);
            } finally {
                SessionUtil.closeSession();
            }
        }
    }

    @Test
    public void syncPurchaseDetail() {
        SyncWarehouseStockJob syncWarehouseStockJob = new SyncWarehouseStockJob();
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setStartTime(LocalDateTime.of(2019, 01, 01 , 00, 00, 00));
        jobPointLog.setEndTime(LocalDateTime.of(2019, 9, 03 , 00, 00, 00));
        jobPointLog.setPageIndex(0);
        jobPointLog.setPageSize(100);
        jobPointLog.setType(5);
        jobPointLog.setIntervalTime(1);
        jobPointLog.setJobName("syncPurchaseDetail");
        syncWarehouseStockJob.syncPurchaseDetail(null, jobPointLog);
    }

    @Test
    public void syncTransferInbound() {
        SyncWarehouseStockJob syncWarehouseStockJob = new SyncWarehouseStockJob();
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setStartTime(LocalDateTime.of(2019, 01, 01 , 00, 00, 00));
        jobPointLog.setEndTime(LocalDateTime.of(2019, 9, 03 , 00, 00, 00));
        jobPointLog.setPageIndex(0);
        jobPointLog.setPageSize(100);
        jobPointLog.setType(5);
        jobPointLog.setIntervalTime(1);
        jobPointLog.setJobName("syncPurchaseDetail");
        syncWarehouseStockJob.syncTransferInbound(null, jobPointLog);
    }

    @Test
    public void syncOrderPick() {
        SyncWarehouseStockJob syncWarehouseStockJob = new SyncWarehouseStockJob();
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setStartTime(LocalDateTime.of(2019, 01, 01 , 00, 00, 00));
        jobPointLog.setEndTime(LocalDateTime.of(2019, 9, 03 , 00, 00, 00));
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(100);
        jobPointLog.setType(5);
        jobPointLog.setIntervalTime(1);
        jobPointLog.setJobName("syncPurchaseDetail");
        syncWarehouseStockJob.syncOrderPick(null, jobPointLog);
    }

    @Test
    public void calculateDutation() {
        CalculateStockRecordJob calculateStockRecordJob = new CalculateStockRecordJob();
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setStartTime(LocalDateTime.of(2019, 07, 01 , 00, 00, 00));
        jobPointLog.setEndTime(LocalDateTime.of(2019, 9, 02 , 00, 00, 00));
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(100);
        jobPointLog.setType(5);
        jobPointLog.setIntervalTime(1);
        jobPointLog.setJobName("syncPurchaseDetail");
        calculateStockRecordJob.executeJob(null, jobPointLog);
    }
}
