package com.bailuntec.balancesheet.mapper;

import com.bailuntec.balancesheet.dto.SemiSupOfferLogDTO;
import org.apache.ibatis.annotations.Insert;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface DcSemiSupplierOfferLogMapper {
    @Insert("<script>" +
            "insert into dc_semi_supplier_offer_log(log_id,supplier_id,supplier_name,unit_id,unit_name,create_time,price,sku_code,sku_name,sku_id) values" +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.logId},#{item.supplierId},#{item.supplierName},#{item.unitId},#{item.unitName},#{item.createTime},#{item.price},#{item.skuCode},#{item.skuName},#{item.skuId})" +
            "</foreach>" +
            " on duplicate key update log_id=values(log_id),supplier_id=values(supplier_id),supplier_name=values(supplier_name),unit_id=values(unit_id),unit_name=values(unit_name)," +
            "create_time=values(create_time),price=values(price),sku_name=values(sku_name),sku_id=values(sku_id)" +
            "</script>")
    void insertOrUpdateSemiSupplierOfferLog(List<SemiSupOfferLogDTO> semiSupOfferLogDTOList);
}