package com.bailuntec.job;


import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.bailuntec.domain.constant.CommonConstant;
import com.bailuntec.domain.entity.DcAutoTurnover;
import com.bailuntec.domain.entity.DcBaseStock;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.DcAutoTurnoverExample;
import com.bailuntec.domain.example.DcBaseStockExample;
import com.bailuntec.mapper.DcAutoSalesForecastStageConfigMapper;
import com.bailuntec.mapper.DcAutoTurnoverMapper;
import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSession;
import org.junit.jupiter.api.Test;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/25 4:43 下午
 */
@Slf4j
public class AutoTurnoverJobTest {

    @Test
    public void syncSpec() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "SPEC", new HashMap<>()), 0),
                jobPointLog);
    }


    @Test
    public void syncAll0() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 8, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }

    @Test
    public void syncAll1() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 8, "NORMAL", new HashMap<>()), 1),
                jobPointLog);
    }

    @Test
    public void syncAll2() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 8, "NORMAL", new HashMap<>()), 2),
                jobPointLog);
    }

    @Test
    public void syncAll3() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 8, "NORMAL", new HashMap<>()), 3),
                jobPointLog);
    }

    @Test
    public void syncAll4() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 8, "NORMAL", new HashMap<>()), 4),
                jobPointLog);
    }

    @Test
    public void syncAll5() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 8, "NORMAL", new HashMap<>()), 5),
                jobPointLog);
    }

    @Test
    public void syncAll6() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 8, "NORMAL", new HashMap<>()), 6),
                jobPointLog);
    }

    @Test
    public void syncAll7() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 8, "NORMAL", new HashMap<>()), 7),
                jobPointLog);
    }


    @Test
    public void sync7_1() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", "show-auto-turnover3", 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }


    @Test
    public void syncIncrement() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }

    @Test
    public void syncAll30() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(39);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }

    @Test
    public void syncAll40() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(49);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }

    @Test
    public void syncAll50() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(59);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }

    @Test
    public void syncAll60() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(69);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }

    @Test
    public void syncAll70() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(79);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }


    @Test
    public void syncAll80() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(89);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }


    @Test
    public void syncAll90() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(99);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }


    @Test
    public void syncAll100() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(109);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }

    @Test
    public void syncAll110() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(119);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }


    @Test
    public void syncAll120() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(129);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }


    @Test
    public void syncAll130() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(146);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }


    @Test
    public void syncAll150() {
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(150);
        jobPointLog.setPageSize(1000);

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        autoTurnoverJob.executeJob(new ShardingContext(new ShardingContexts("x", null, 1, "NORMAL", new HashMap<>()), 0),
                jobPointLog);
    }

    @Test
    public void syncPartAutoTurnover() {

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();

        try (SqlSession sqlSession = SessionUtil.getFactory().openSession(true)) {

            DcAutoSalesForecastStageConfigMapper dcAutoSalesForecastStageConfigMapper = sqlSession.getMapper(DcAutoSalesForecastStageConfigMapper.class);
            DcBaseStockMapper dcBaseStockMapper = sqlSession.getMapper(DcBaseStockMapper.class);

            List<DcAutoTurnover> dcAutoTurnoverList = dcAutoSalesForecastStageConfigMapper.selectTestSyncAutoTurnoverList();

            dcAutoTurnoverList.stream().parallel().forEach(dcAutoTurnover -> {

                DcBaseStock dcBaseStock = dcBaseStockMapper.selectOneByExample(DcBaseStockExample.newAndCreateCriteria()
                        .andBailunSkuEqualTo(dcAutoTurnover.getBailunSku())
                        .andWarehouseCodeEqualTo(dcAutoTurnover.getWarehouseCode())
                        .example());

                try {
                    if (dcBaseStock != null) {
                        log.info("计算周转开始 bailunSku:{} , warehouseCode:{}", dcBaseStock.getBailunSku(), dcBaseStock.getWarehouseCode());
                        autoTurnoverJob.autoTurnoverFromStock(DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(LocalDate.now()), dcBaseStock);
                        log.info("计算周转结束 bailunSku:{} , warehouseCode:{}", dcBaseStock.getBailunSku(), dcBaseStock.getWarehouseCode());
                    } else {
                        log.error("没有找到周转对应的baseStock");
                    }
                } catch (Exception e) {
                    log.error("计算周转失败 :{}", e.getMessage(), e);
                }
            });
        }

    }

    /**
     * 最简单的写
     * <p>1. 创建excel对应的实体对象 参照{@link com.alibaba}
     * <p>2. 直接写即可
     */
    @Test
    public void simpleWrite() {
        // 这里 需要指定写用哪个class去读，然后写到第一个sheet，名字为模板 然后文件流会自动关闭
        // 如果这里想使用03 则 传入excelType参数即可
        EasyExcel.write("/Users/huluobin/Downloads/turnover.xlsx", DcAutoTurnoverExcel.class).sheet("turnover").doWrite(
                SessionUtil.getSession().getMapper(DcAutoTurnoverMapper.class).selectByExample(DcAutoTurnoverExample.newAndCreateCriteria()
                        .andGmtModifiedGreaterThan(LocalDateTime.of(2020, 9, 8, 14, 50, 0))
                        .example())
                        .stream().map(dcAutoTurnover -> {
                    DcAutoTurnoverExcel dcAutoTurnoverExcel = new DcAutoTurnoverExcel();
                    dcAutoTurnoverExcel.setBailunSku(dcAutoTurnover.getBailunSku());
                    dcAutoTurnoverExcel.setWarehouseCode(dcAutoTurnover.getWarehouseCode());
                    return dcAutoTurnoverExcel;
                })
                        .collect(Collectors.toList())
        );
    }

    @Data
    static class DcAutoTurnoverExcel {

        @ExcelProperty("百伦sku")
        private String bailunSku;

        @ExcelProperty("仓库编码")
        private String warehouseCode;
    }

    @Test
    public void testOneSku() {

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();

        try (SqlSession sqlSession = SessionUtil.getFactory().openSession(true)) {

            DcAutoSalesForecastStageConfigMapper dcAutoSalesForecastStageConfigMapper = sqlSession.getMapper(DcAutoSalesForecastStageConfigMapper.class);
            DcBaseStockMapper dcBaseStockMapper = sqlSession.getMapper(DcBaseStockMapper.class);

            DcBaseStock dcBaseStock = dcBaseStockMapper.selectOneByExample(DcBaseStockExample.newAndCreateCriteria()
                    .andBailunSkuEqualTo("948881401")
                    .andWarehouseCodeEqualTo("GZBLWH")
                    .example());

            try {
                log.info("计算周转开始 bailunSku:{} , warehouseCode:{}", dcBaseStock.getBailunSku(), dcBaseStock.getWarehouseCode());
                autoTurnoverJob.autoTurnoverFromStock(DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(LocalDate.now()), dcBaseStock);
                log.info("计算周转结束 bailunSku:{} , warehouseCode:{}", dcBaseStock.getBailunSku(), dcBaseStock.getWarehouseCode());

            } catch (Exception e) {
                log.error("计算周转失败 :{}", e.getMessage(), e);
            }
        }
    }
}
