package com.bailuntec.serviceImpl;

import com.alibaba.fastjson.JSONObject;
import com.bailuntec.domain.entity.BaseStockVO;
import com.bailuntec.domain.entity.DcBaseStock;
import com.bailuntec.mapper.BaseStockMapper;
import com.bailuntec.service.InventoryService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

import java.util.Date;
import java.util.List;

@Service
public class InventoryServiceImpl implements InventoryService {

    @Autowired
    private BaseStockMapper stockMapper;

    @Override
    public List<BaseStockVO> listStockInfo(JSONObject jsonObject) {
        String skus = jsonObject.getString("skus");
        List<BaseStockVO> dcDailyInventories = null;
        if (skus != null && !StringUtils.isEmpty(skus.trim())) {
            String[] split = skus.split(",");
            if (split.length > 1000) {
                throw  new RuntimeException("传入的SKU数量应少于1000");
            }
            dcDailyInventories = stockMapper.listStock(split);
        }
        return dcDailyInventories;
    }

    @Override
    public PageInfo<DcBaseStock> listBaseStockInfo(JSONObject jsonObject) {
        int pageIndex = jsonObject.getIntValue("pageIndex");
        int pageSize = jsonObject.getIntValue("pageSize") > 1000 ? 1000 :jsonObject.getIntValue("pageSize");
        Date startTime = jsonObject.getDate("startTime");
        Date endTime = jsonObject.getDate("endTime");
        Example example = new Example(DcBaseStock.class);
        example.createCriteria().andBetween("gmtModified", startTime, endTime);
        PageHelper.startPage(pageIndex, pageSize);
        List<DcBaseStock> dcDailyInventories = stockMapper.selectByExample(example);
        PageInfo<DcBaseStock> pageInfo = PageInfo.of(dcDailyInventories);
        return pageInfo;
    }
}
