package com.bailuntec.job;


import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.bailuntec.domain.entity.DcSemiStockProd;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.pojo.SemiStockReportInfo;
import com.bailuntec.mapper.DcSemiStockProdMapper;
import com.bailuntec.mapper.JobPointLogMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.ExceptionUtil;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.PropertiesUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;

@Slf4j
public class SemiStockProdDailySyncJob extends PointJob {

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        DcSemiStockProdMapper mapper = SessionUtil.getSession().getMapper(DcSemiStockProdMapper.class);
        mapper.insertDaily();
    }
}
